/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import nl.colorize.multimedialib.graphics.Align;
import nl.colorize.multimedialib.graphics.Animation;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.Sprite;
import nl.colorize.multimedialib.graphics.SpriteSheet;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.RandomGenerator;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Audio;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GraphicsContext2D;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.InternetAccess;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.Updatable;
import nl.colorize.multimedialib.scene.ActionManager;
import nl.colorize.multimedialib.scene.Application;
import nl.colorize.multimedialib.scene.Effect;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.ui.Button;
import nl.colorize.multimedialib.scene.ui.Location;
import nl.colorize.multimedialib.scene.ui.SelectBox;
import nl.colorize.multimedialib.scene.ui.TextField;
import nl.colorize.multimedialib.scene.ui.Widget;
import nl.colorize.multimedialib.scene.ui.WidgetStyle;
import nl.colorize.util.LogHelper;
import nl.colorize.util.animation.Interpolation;
import nl.colorize.util.animation.Timeline;
import nl.colorize.util.http.Headers;

public class Demo2D
implements Scene {
    private Renderer renderer;
    private SpriteSheet marioSpriteSheet;
    private TTFont font;
    private List<Mario> marios;
    private Audio audioClip;
    private ActionManager effectManager;
    private boolean canvasMask;
    private List<Widget> uiWidgets;
    public static final int DEFAULT_CANVAS_WIDTH = 800;
    public static final int DEFAULT_CANVAS_HEIGHT = 600;
    public static final int DEFAULT_FRAMERATE = 60;
    private static final FilePointer MARIO_SPRITES_FILE = new FilePointer("mario.png");
    private static final FilePointer AUDIO_FILE = new FilePointer("test.mp3");
    private static final FilePointer UI_WIDGET_FILE = new FilePointer("ui-widget-background.png");
    private static final FilePointer COLORIZE_LOGO = new FilePointer("colorize-logo.png");
    private static final int INITIAL_MARIOS = 20;
    private static final List<String> DIRECTIONS = ImmutableList.of((Object)"north", (Object)"east", (Object)"south", (Object)"west");
    private static final int NUM_BUTTONS = 7;
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_HEIGHT = 25;
    private static final ColorRGB RED_BUTTON = new ColorRGB(228, 93, 97);
    private static final ColorRGB GREEN_BUTTON = ColorRGB.parseHex("#72A725");
    private static final ColorRGB BACKGROUND_COLOR = ColorRGB.parseHex("#343434");
    private static final Transform MASK_TRANSFORM = Transform.withMask(ColorRGB.WHITE);
    private static final String TEST_URL = "http://www.colorize.nl";
    private static final Logger LOGGER = LogHelper.getLogger(Demo2D.class);

    @Override
    public void start(Application app) {
        this.renderer = app.getRenderer();
        MediaLoader mediaLoader = this.renderer.getMediaLoader();
        this.initMarioSprites(mediaLoader);
        this.marios = new ArrayList<Mario>();
        this.addMarios(20);
        this.font = mediaLoader.loadDefaultFont(12, ColorRGB.WHITE);
        this.audioClip = mediaLoader.loadAudio(AUDIO_FILE);
        this.effectManager = new ActionManager();
        this.uiWidgets = Collections.emptyList();
        this.initEffects(app.getMediaLoader(), app.getCanvas());
    }

    private void initMarioSprites(MediaLoader mediaLoader) {
        Image image = mediaLoader.loadImage(MARIO_SPRITES_FILE);
        this.marioSpriteSheet = new SpriteSheet(image);
        int y = 0;
        for (String direction : ImmutableList.of((Object)"north", (Object)"east", (Object)"south", (Object)"west")) {
            for (int i = 0; i <= 4; ++i) {
                this.marioSpriteSheet.markRegion(direction + "_" + i, new Rect(i * 48, y, 48.0f, 64.0f));
            }
            y += 64;
        }
    }

    private void initEffects(MediaLoader mediaLoader, Canvas canvas) {
        Timeline animationTimeline = new Timeline(Interpolation.LINEAR, true);
        animationTimeline.addKeyFrame(0.0f, 0.0f);
        animationTimeline.addKeyFrame(2.0f, 1.0f);
        animationTimeline.addKeyFrame(4.0f, 0.0f);
        Image colorizeLogo = mediaLoader.loadImage(COLORIZE_LOGO);
        Effect effect = Effect.forImage(colorizeLogo, animationTimeline);
        Transform transform = effect.getTransform();
        effect.modify(value -> effect.setPosition(50.0f, canvas.getHeight() - 50));
        effect.modify(value -> transform.setScale(80 + Math.round(value.floatValue() * 40.0f)));
        effect.modifyFrameUpdate(dt -> transform.addRotation(Math.round(dt * 100.0f)));
        this.effectManager.play(effect);
    }

    @Override
    public void update(Application app, float deltaTime) {
        InputDevice inputDevice = this.renderer.getInputDevice();
        this.handleClick(inputDevice, app.getCanvas());
        this.handleSystemControls(inputDevice, app.getInternetAccess());
        for (Mario mario : this.marios) {
            mario.update(deltaTime);
        }
        this.effectManager.update(deltaTime);
        this.uiWidgets.forEach(widget -> widget.update(deltaTime));
    }

    private void handleClick(InputDevice inputDevice, Canvas canvas) {
        for (int i = 0; i <= 7; ++i) {
            if (!this.isButtonClicked(inputDevice, i)) continue;
            this.handleButtonClick(i);
            return;
        }
        if (this.checkMarioClick(inputDevice)) {
            return;
        }
        if (inputDevice.isPointerReleased(canvas.getBounds())) {
            this.createTouchMarker(inputDevice.getPointers());
        }
    }

    private boolean checkMarioClick(InputDevice inputDevice) {
        for (Mario mario : this.marios) {
            if (!inputDevice.isPointerReleased(mario.getBounds())) continue;
            mario.mask = !mario.mask;
            return true;
        }
        return false;
    }

    private boolean isButtonClicked(InputDevice input, int buttonIndex) {
        Rect buttonBounds = new Rect(this.renderer.getCanvas().getWidth() - 100, buttonIndex * 30, 100.0f, 25.0f);
        return input.isPointerReleased(buttonBounds);
    }

    private void handleButtonClick(int index) {
        switch (index) {
            case 0: {
                this.addMarios(10);
                break;
            }
            case 1: {
                this.removeMarios(10);
                break;
            }
            case 2: {
                this.audioClip.play();
                break;
            }
            case 3: {
                this.canvasMask = !this.canvasMask;
                break;
            }
            case 4: {
                this.initUIWidgets(this.renderer.getMediaLoader(), this.renderer.getInputDevice());
                break;
            }
        }
    }

    private void handleSystemControls(InputDevice input, InternetAccess network) {
        if (input.isKeyReleased(KeyCode.U)) {
            this.sendRequest(network);
        }
        ImmutableList canvasControls = ImmutableList.of((Object)((Object)KeyCode.N1), (Object)((Object)KeyCode.N2), (Object)((Object)KeyCode.N3), (Object)((Object)KeyCode.N4));
        for (int i = 0; i < canvasControls.size(); ++i) {
            if (!input.isKeyReleased((KeyCode)((Object)canvasControls.get(i)))) continue;
            this.changeCanvasStrategy(i);
        }
    }

    private void changeCanvasStrategy(int index) {
        Canvas.ZoomStrategy strategy = Canvas.ZoomStrategy.values()[index];
        LOGGER.info("Changing canvas zoom strategy to " + strategy);
        this.renderer.getCanvas().changeStrategy(strategy);
    }

    private void initUIWidgets(MediaLoader mediaLoader, InputDevice input) {
        if (!this.uiWidgets.isEmpty()) {
            this.uiWidgets = Collections.emptyList();
            return;
        }
        Image widget = mediaLoader.loadImage(UI_WIDGET_FILE);
        Button button = new Button(new WidgetStyle(widget, this.font), "Click");
        button.setLocation(Location.fixed(200.0f, 200.0f));
        button.setClickHandler(input, () -> LOGGER.info("Button clicked"));
        SelectBox select = new SelectBox(new WidgetStyle(widget, this.font), (List<String>)ImmutableList.of((Object)"A", (Object)"B", (Object)"C"), "A");
        select.setLocation(Location.fixed(200.0f, 240.0f));
        select.setClickHandler(input, item -> LOGGER.info("Selected item " + item));
        TextField textField = new TextField(new WidgetStyle(widget, this.font), "Enter text:");
        textField.setLocation(Location.fixed(200.0f, 280.0f));
        textField.setChangeHandler(input, text -> LOGGER.info("Entered text: " + text));
        this.uiWidgets = ImmutableList.of((Object)button, (Object)select, (Object)textField);
    }

    private void createTouchMarker(List<Point2D> positions) {
        for (Point2D position : positions) {
            Timeline timeline = new Timeline();
            timeline.addKeyFrame(0.0f, 100.0f);
            timeline.addKeyFrame(1.0f, 100.0f);
            timeline.addKeyFrame(1.5f, 0.0f);
            String text = Math.round(position.getX()) + ", " + Math.round(position.getY());
            Effect effect = Effect.forTextAlpha(text, this.font, Align.LEFT, timeline);
            effect.setPosition(position);
            this.effectManager.play(effect);
        }
    }

    @Override
    public void render(Application app, GraphicsContext2D graphics) {
        graphics.drawBackground(BACKGROUND_COLOR);
        this.drawSprites(graphics);
        this.drawHUD(app, graphics);
        if (this.canvasMask) {
            graphics.drawRect(new Rect(10.0f, 10.0f, 780.0f, 580.0f), ColorRGB.WHITE, Transform.withAlpha(10));
        }
        this.effectManager.render(graphics);
        this.uiWidgets.forEach(widget -> widget.render(graphics));
    }

    private void drawSprites(GraphicsContext2D graphics) {
        for (Mario mario : this.marios) {
            mario.sprite.setPosition(mario.position);
            mario.sprite.setTransform(mario.mask ? MASK_TRANSFORM : null);
            graphics.drawSprite(mario.sprite);
        }
    }

    private void drawHUD(Application app, GraphicsContext2D graphics) {
        this.drawButton(graphics, "Add sprites", RED_BUTTON, 0);
        this.drawButton(graphics, "Remove sprites", RED_BUTTON, 30);
        this.drawButton(graphics, "Play sound", GREEN_BUTTON, 60);
        this.drawButton(graphics, "Canvas bounds", GREEN_BUTTON, 90);
        this.drawButton(graphics, "UI widgets", GREEN_BUTTON, 120);
        Canvas canvas = this.renderer.getCanvas();
        graphics.drawText("Canvas:  " + canvas, this.font, 20.0f, 20.0f);
        graphics.drawText("Framerate:  " + Math.round(app.getAverageFramerate()), this.font, 20.0f, 40.0f);
        graphics.drawText("Frame time:  " + Math.round(app.getAverageFrameTime()) + "ms", this.font, 20.0f, 60.0f);
        graphics.drawText("Sprites:  " + this.marios.size(), this.font, 20.0f, 80.0f);
    }

    private void drawButton(GraphicsContext2D graphics, String label, ColorRGB background, int y) {
        graphics.drawRect(new Rect(this.renderer.getCanvas().getWidth() - 100 - 2, y + 2, 100.0f, 25.0f), background, null);
        graphics.drawText(label, this.font, (float)this.renderer.getCanvas().getWidth() - 50.0f, y + 17, Align.CENTER);
    }

    public void addMarios(int amount) {
        for (int i = 0; i < amount; ++i) {
            Sprite marioSprite = this.createMarioSprite();
            this.marios.add(new Mario(marioSprite, new Rect(0.0f, 0.0f, this.renderer.getCanvas().getWidth(), this.renderer.getCanvas().getHeight())));
        }
    }

    private Sprite createMarioSprite() {
        Sprite marioSprite = new Sprite();
        for (String direction : DIRECTIONS) {
            List<Image> frames = this.marioSpriteSheet.get(direction + "_0", direction + "_1", direction + "_2", direction + "_3", direction + "_4");
            Animation anim = new Animation(frames, 0.1f, true);
            marioSprite.addState(direction, anim);
        }
        return marioSprite;
    }

    private void removeMarios(int amount) {
        for (int i = 0; i < amount && !this.marios.isEmpty(); ++i) {
            this.marios.remove(this.marios.size() - 1);
        }
    }

    private void sendRequest(InternetAccess internetAccess) {
        LOGGER.info("Sending request to http://www.colorize.nl");
        Headers headers = new Headers();
        headers.add("X-Do-Not-Track", "1");
        internetAccess.get(TEST_URL, headers).then(LOGGER::info).thenCatch(error -> LOGGER.warning("Sending request failed"));
    }

    private static class Mario
    implements Updatable {
        private Sprite sprite;
        private Rect canvasBounds;
        private Point2D position;
        private int direction;
        private int speed;
        private boolean mask;

        public Mario(Sprite sprite, Rect canvasBounds) {
            this.sprite = sprite;
            this.position = new Point2D(RandomGenerator.getFloat(0.0f, canvasBounds.getWidth()), RandomGenerator.getFloat(0.0f, canvasBounds.getHeight()));
            this.canvasBounds = canvasBounds;
            this.direction = RandomGenerator.getInt(0, 4);
            this.speed = RandomGenerator.getInt(1, 4);
            this.mask = false;
        }

        @Override
        public void update(float deltaTime) {
            this.sprite.changeState(DIRECTIONS.get(this.direction));
            this.sprite.update(deltaTime);
            switch (this.direction) {
                case 0: {
                    this.position.add(0.0f, -this.speed);
                    break;
                }
                case 1: {
                    this.position.add(this.speed, 0.0f);
                    break;
                }
                case 2: {
                    this.position.add(0.0f, this.speed);
                    break;
                }
                case 3: {
                    this.position.add(-this.speed, 0.0f);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.checkBounds();
        }

        private void checkBounds() {
            if (this.position.getX() < 0.0f || this.position.getX() > this.canvasBounds.getWidth() || this.position.getY() < 0.0f || this.position.getY() > this.canvasBounds.getHeight()) {
                this.direction = (this.direction + 2) % 4;
            }
        }

        private Rect getBounds() {
            return new Rect(this.position.getX() - (float)this.sprite.getCurrentWidth() / 2.0f, this.position.getY() - (float)this.sprite.getCurrentHeight() / 2.0f, this.sprite.getCurrentWidth(), this.sprite.getCurrentHeight());
        }
    }
}

