/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.PolygonMesh;
import nl.colorize.multimedialib.graphics.PolygonModel;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.math.RandomGenerator;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GraphicsContext2D;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Stage;
import nl.colorize.multimedialib.scene.Application;
import nl.colorize.multimedialib.scene.Scene;

public class Demo3D
implements Scene {
    private TTFont font;
    private Image logo;
    private List<PolygonModel> models;
    private List<Point2D> walkVectors;
    private Point2D pointer = new Point2D(0.0f, 0.0f);
    public static final int CANVAS_WIDTH = 800;
    public static final int CANVAS_HEIGHT = 600;
    private static final FilePointer MODEL_FILE = new FilePointer("model.fbx");
    private static final FilePointer LOGO_FILE = new FilePointer("colorize-logo.png");
    private static final float AREA_SIZE = 50.0f;
    private static final float MAX_WALK_SPEED = 0.1f;

    @Override
    public void start(Application app) {
        MediaLoader mediaLoader = app.getMediaLoader();
        this.font = mediaLoader.loadDefaultFont(12, ColorRGB.WHITE);
        this.logo = mediaLoader.loadImage(LOGO_FILE);
        this.createFloor(app.getStage());
        this.createModels(app.getStage(), mediaLoader);
        Stage stage = app.getStage();
        stage.moveCamera(new Point3D(0.0f, 30.0f, 30.000002f), new Point3D(0.0f, 0.0f, 0.0f));
    }

    private void createFloor(Stage stage) {
        boolean white = true;
        for (int i = -5; i <= 5; ++i) {
            for (int j = -5; j <= 5; ++j) {
                float tileSize = 4.5454545f;
                ColorRGB color = white ? ColorRGB.WHITE : new ColorRGB(50, 50, 50);
                PolygonModel tile = this.createTile(stage, tileSize, color, i == 0 && j == 0);
                tile.setPosition((float)i * tileSize, 0.0f, (float)j * tileSize);
                stage.add(tile);
                white = !white;
            }
        }
    }

    private PolygonModel createTile(Stage stage, float tileSize, ColorRGB color, boolean center) {
        if (center) {
            PolygonMesh tileMesh = stage.createQuad(new Point2D(tileSize, tileSize), this.logo);
            PolygonModel model = tileMesh.createModel();
            model.setRotation(0.0f, 1.0f, 0.0f, 90.0f);
            return model;
        }
        PolygonMesh tileMesh = stage.createQuad(new Point2D(tileSize, tileSize), color);
        return tileMesh.createModel();
    }

    private void createModels(Stage stage, MediaLoader mediaLoader) {
        this.models = new ArrayList<PolygonModel>();
        this.walkVectors = new ArrayList<Point2D>();
        PolygonMesh mesh = mediaLoader.loadMesh(MODEL_FILE);
        for (int i = 0; i < 100; ++i) {
            PolygonModel model = mesh.createModel();
            model.setPosition(this.generateRandomModelPosition());
            model.setRotation(0.0f, 1.0f, 0.0f, -90.0f);
            stage.add(model);
            this.models.add(model);
            this.walkVectors.add(this.generateRandomWalkVector());
        }
    }

    private Point3D generateRandomModelPosition() {
        float x = RandomGenerator.getFloat(-25.0f, 25.0f);
        float z = RandomGenerator.getFloat(-25.0f, 25.0f);
        return new Point3D(x, 0.5f, z);
    }

    private Point2D generateRandomWalkVector() {
        float x = RandomGenerator.getFloat(-0.1f, 0.1f);
        float z = RandomGenerator.getFloat(-0.1f, 0.1f);
        return new Point2D(x, z);
    }

    @Override
    public void update(Application app, float deltaTime) {
        InputDevice inputDevice = app.getInputDevice();
        if (inputDevice.isPointerReleased(app.getCanvas().getBounds())) {
            this.pointer = inputDevice.getPointers().get(0);
        }
        this.updateModels(app.getStage());
    }

    private void updateModels(Stage stage) {
        Rect areaBounds = new Rect(-25.0f, -25.0f, 50.0f, 50.0f);
        for (int i = 0; i < this.models.size(); ++i) {
            PolygonModel model = this.models.get(i);
            Point2D walkVector = this.walkVectors.get(i);
            Point3D position = model.getPosition();
            position.add(walkVector.getX(), 0.0f, walkVector.getY());
            if (areaBounds.contains(position.getX(), position.getZ())) continue;
            Point2D walk = new Point2D(-this.walkVectors.get(i).getX(), -this.walkVectors.get(i).getY());
            this.walkVectors.set(i, walk);
            stage.playAnimation(model, model.getAnimation("Cube|Spin"), false);
        }
    }

    @Override
    public void render(Application app, GraphicsContext2D graphics) {
        Canvas canvas = graphics.getCanvas();
        graphics.drawText("Canvas:  " + canvas, this.font, 20.0f, 20.0f);
        graphics.drawText("Framerate:  " + Math.round(app.getAverageFramerate()), this.font, 20.0f, 40.0f);
        graphics.drawText("Frame time:  " + Math.round(app.getAverageFrameTime()) + "ms", this.font, 20.0f, 60.0f);
        graphics.drawText("Models:  " + this.models.size(), this.font, 20.0f, 80.0f);
        graphics.drawText("Pointer:  " + this.pointer, this.font, 20.0f, 100.0f);
    }
}

