/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.graphics.Image;

public class Animation {
    private List<FrameInfo> frames = new ArrayList<FrameInfo>();
    private boolean loop;

    public Animation(boolean loop) {
        this.loop = loop;
    }

    public Animation(List<Image> frames, float frameTime, boolean loop) {
        this(loop);
        for (Image frame : frames) {
            this.addFrame(frame, frameTime);
        }
    }

    public Animation(Image frame) {
        this(false);
        this.addFrame(frame, 0.0f);
    }

    public void addFrame(Image frame, float frameTime) {
        Preconditions.checkArgument((frameTime >= 0.0f ? 1 : 0) != 0, (Object)("Invalid frame time: " + frameTime));
        this.frames.add(new FrameInfo(frame, frameTime));
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    public List<Image> getFrameImages() {
        return this.frames.stream().map(frame -> frame.image).collect(Collectors.toList());
    }

    public Image getFrameAtIndex(int index) {
        return this.frames.get((int)index).image;
    }

    public Image getFrameAtTime(float time) {
        Preconditions.checkState((!this.frames.isEmpty() ? 1 : 0) != 0, (Object)"Animation does not contain any frames");
        if (this.frames.size() == 1) {
            return this.frames.get((int)0).image;
        }
        if (this.loop) {
            time %= this.getDuration();
        }
        for (FrameInfo frame : this.frames) {
            if (!((time -= frame.frameTime) < 0.0f)) continue;
            return frame.image;
        }
        return this.frames.get((int)(this.frames.size() - 1)).image;
    }

    public float getDuration() {
        if (this.frames.size() <= 1) {
            return 0.0f;
        }
        float duration = 0.0f;
        for (FrameInfo frame : this.frames) {
            duration += frame.frameTime;
        }
        return duration;
    }

    public void setFrameTime(int index, float frameTime) {
        Preconditions.checkArgument((frameTime >= 0.0f ? 1 : 0) != 0, (Object)("Invalid frame time: " + frameTime));
        this.frames.get((int)index).frameTime = frameTime;
    }

    public float getFrameTime(int index) {
        return this.frames.get((int)index).frameTime;
    }

    public boolean isLoop() {
        return this.loop;
    }

    private static class FrameInfo {
        private Image image;
        private float frameTime;

        public FrameInfo(Image image, float frameTime) {
            this.image = image;
            this.frameTime = frameTime;
        }
    }
}

