/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import nl.colorize.multimedialib.graphics.Align;
import nl.colorize.multimedialib.graphics.AlphaTransform;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.Sprite;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Canvas;

public interface GraphicsContext2D {
    public Canvas getCanvas();

    default public int getCanvasWidth() {
        return this.getCanvas().getWidth();
    }

    default public int getCanvasHeight() {
        return this.getCanvas().getHeight();
    }

    public void drawBackground(ColorRGB var1);

    public void drawRect(Rect var1, ColorRGB var2, AlphaTransform var3);

    default public void drawRect(Rect rect, ColorRGB color, int alpha) {
        this.drawRect(rect, color, () -> alpha);
    }

    default public void drawRect(Rect rect, ColorRGB color) {
        this.drawRect(rect, color, null);
    }

    public void drawCircle(Circle var1, ColorRGB var2, AlphaTransform var3);

    default public void drawCircle(Circle circle, ColorRGB color, int alpha) {
        this.drawCircle(circle, color, () -> alpha);
    }

    default public void drawCircle(Circle circle, ColorRGB color) {
        this.drawCircle(circle, color, null);
    }

    public void drawPolygon(Polygon var1, ColorRGB var2, AlphaTransform var3);

    default public void drawPolygon(Polygon polygon, ColorRGB color, int alpha) {
        this.drawPolygon(polygon, color, () -> alpha);
    }

    default public void drawPolygon(Polygon polygon, ColorRGB color) {
        this.drawPolygon(polygon, color, null);
    }

    public void drawImage(Image var1, float var2, float var3, Transform var4);

    default public void drawImage(Image image, float x, float y) {
        this.drawImage(image, x, y, null);
    }

    default public void drawSprite(Sprite sprite) {
        this.drawImage(sprite.getCurrentGraphics(), sprite.getPosition().getX(), sprite.getPosition().getY(), sprite.getTransform());
    }

    default public void fillImage(Image image) {
        int scaleX = Math.round((float)this.getCanvasWidth() / (float)image.getWidth() * 100.0f);
        int scaleY = Math.round((float)this.getCanvasHeight() / (float)image.getHeight() * 100.0f);
        Transform transform = Transform.withScale(scaleX, scaleY);
        this.drawImage(image, (float)this.getCanvasWidth() / 2.0f, (float)this.getCanvasHeight() / 2.0f, transform);
    }

    public void drawText(String var1, TTFont var2, float var3, float var4, Align var5, AlphaTransform var6);

    default public void drawText(String text, TTFont font, float x, float y, Align align) {
        this.drawText(text, font, x, y, align, null);
    }

    default public void drawText(String text, TTFont font, float x, float y) {
        this.drawText(text, font, x, y, Align.LEFT, null);
    }
}

