/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.renderer.ApplicationData;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.InternetAccess;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.NestedRenderCallback;
import nl.colorize.multimedialib.renderer.RenderCallback;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.Stage;
import nl.colorize.multimedialib.renderer.teavm.AnimationFrameCallback;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphicsContext;
import nl.colorize.multimedialib.renderer.teavm.TeaInputDevice;
import nl.colorize.multimedialib.renderer.teavm.TeaInternetAccess;
import nl.colorize.multimedialib.renderer.teavm.TeaLocalStorage;
import nl.colorize.multimedialib.renderer.teavm.TeaMediaLoader;
import nl.colorize.multimedialib.renderer.teavm.TeaStage;
import nl.colorize.util.PlatformFamily;

public class TeaRenderer
implements Renderer,
AnimationFrameCallback {
    private NestedRenderCallback callbacks = new NestedRenderCallback();
    private Canvas canvas;
    private TeaGraphicsContext graphics;
    private TeaStage stage;
    private TeaInputDevice inputDevice;
    private TeaMediaLoader mediaLoader;

    public TeaRenderer(Canvas canvas) {
        this.canvas = canvas;
        this.graphics = new TeaGraphicsContext(canvas);
        this.inputDevice = new TeaInputDevice(canvas, this.getPlatform());
        this.mediaLoader = new TeaMediaLoader(this.getSupportedGraphicsMode());
        if (this.getSupportedGraphicsMode() == GraphicsMode.ALL) {
            this.stage = new TeaStage();
        }
    }

    @Override
    public void attach(RenderCallback callback) {
        this.callbacks.add(callback);
    }

    @Override
    public void start() {
        Browser.startAnimationLoop(this);
    }

    @Override
    public GraphicsMode getSupportedGraphicsMode() {
        String graphicsType = Browser.getGraphicsType();
        if (graphicsType.equals("3d")) {
            return GraphicsMode.ALL;
        }
        return GraphicsMode.G2D;
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas;
    }

    @Override
    public Stage getStage() {
        Preconditions.checkState((this.stage != null ? 1 : 0) != 0, (Object)"Support for 3D graphics is not enabled");
        return this.stage;
    }

    @Override
    public InputDevice getInputDevice() {
        return this.inputDevice;
    }

    @Override
    public MediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    @Override
    public ApplicationData getApplicationData(String appName) {
        return new TeaLocalStorage();
    }

    @Override
    public InternetAccess getInternetAccess() {
        return new TeaInternetAccess();
    }

    @Override
    public void onFrame(float deltaTime, boolean render) {
        this.updateCanvas();
        this.inputDevice.update(deltaTime);
        if (this.stage != null) {
            this.stage.update(deltaTime);
        }
        if (this.isReady()) {
            this.callbacks.update(this, deltaTime);
            if (render) {
                this.callbacks.render(this, this.graphics);
            }
        }
    }

    private boolean isReady() {
        int canvasWidth = Math.round(Browser.getCanvasWidth());
        int canvasHeight = Math.round(Browser.getCanvasHeight());
        return canvasWidth > 0 && canvasHeight > 0 && this.mediaLoader.checkLoadingProgress();
    }

    private void updateCanvas() {
        int canvasWidth = Math.round(Browser.getCanvasWidth());
        int canvasHeight = Math.round(Browser.getCanvasHeight());
        if (canvasWidth > 0 && canvasHeight > 0) {
            this.canvas.resizeScreen(canvasWidth, canvasHeight);
        }
    }

    @Override
    public PlatformFamily getPlatform() {
        String userAgent = Browser.getUserAgent().toLowerCase();
        if (userAgent.contains("iphone") || userAgent.contains("ipad")) {
            return PlatformFamily.IOS;
        }
        if (userAgent.contains("android")) {
            return PlatformFamily.ANDROID;
        }
        if (userAgent.contains("mac")) {
            return PlatformFamily.MAC;
        }
        return PlatformFamily.WINDOWS;
    }

    @Override
    public String takeScreenshot() {
        return Browser.takeScreenshot();
    }
}

