/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.google.common.base.Charsets;
import java.util.logging.Logger;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.java2d.Java2DRenderer;
import nl.colorize.multimedialib.renderer.java2d.WindowOptions;
import nl.colorize.multimedialib.renderer.libgdx.GDXRenderer;
import nl.colorize.multimedialib.scene.Application;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.tool.CommandLineTool;
import nl.colorize.multimedialib.tool.Demo2D;
import nl.colorize.multimedialib.tool.Demo3D;
import nl.colorize.util.LogHelper;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.swing.ApplicationMenuListener;
import nl.colorize.util.swing.Popups;
import org.kohsuke.args4j.Option;

public class DemoLauncher
extends CommandLineTool
implements ApplicationMenuListener {
    @Option(name="-renderer", required=true, usage="Renderer to use for the demo (java2d, gdx)")
    public String rendererName;
    @Option(name="-graphics", required=true, usage="Either '2d' or '3d'")
    public String graphics;
    @Option(name="-framerate", required=false, usage="Demo framerate, default is 60 fps")
    public int framerate = 60;
    @Option(name="-canvas", required=false, usage="Uses a fixed canvas size to display graphics")
    public boolean canvas = false;
    @Option(name="-orientationlock", required=false, usage="Restricts the demo to landscape orientation")
    public boolean orientationLock = false;
    @Option(name="-verification", required=false, usage="Prints instructions for verification")
    public boolean verification = false;
    private static final ResourceFile VERIFICATION_FILE = new ResourceFile("verification-instructions.txt");
    private static final Logger LOGGER = LogHelper.getLogger(DemoLauncher.class);

    public static void main(String[] args) {
        DemoLauncher demo = new DemoLauncher();
        demo.start(args);
    }

    @Override
    public void run() {
        this.start();
        if (this.verification) {
            this.printVerificationInstructions();
        }
    }

    private void start() {
        Renderer renderer = this.createRenderer();
        Application.start(renderer, this.createDemoScene());
    }

    private Renderer createRenderer() {
        switch (this.rendererName) {
            case "java2d": {
                return this.createJava2DRenderer();
            }
            case "gdx": {
                return this.createGDXRenderer();
            }
        }
        throw new IllegalArgumentException("Renderer not supported: " + this.rendererName);
    }

    private Java2DRenderer createJava2DRenderer() {
        return new Java2DRenderer(this.getCanvas(), this.framerate, this.getWindowOptions());
    }

    private GDXRenderer createGDXRenderer() {
        GDXRenderer renderer = new GDXRenderer(this.getCanvas(), this.framerate, this.getWindowOptions());
        if (this.graphics.equals("3d")) {
            renderer.enableFreeCamera();
        }
        return renderer;
    }

    private Scene createDemoScene() {
        switch (this.graphics) {
            case "2d": {
                return new Demo2D();
            }
            case "3d": {
                return new Demo3D();
            }
        }
        throw new IllegalArgumentException("Unknown graphics mode: " + this.graphics);
    }

    private Canvas getCanvas() {
        if (this.canvas) {
            return Canvas.fixed(800, 600);
        }
        return Canvas.flexible(800, 600);
    }

    private WindowOptions getWindowOptions() {
        WindowOptions windowOptions = new WindowOptions("MultimediaLib - Demo");
        windowOptions.setAppMenuListener(this);
        return windowOptions;
    }

    private void printVerificationInstructions() {
        String instructions = VERIFICATION_FILE.read(Charsets.UTF_8);
        LOGGER.info("\n\n" + instructions);
    }

    public void onQuit() {
        System.exit(0);
    }

    public void onAbout() {
        Popups.message(null, (String)"MultimediaLib - demo application");
    }
}

