/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import com.badlogic.gdx.math.MathUtils;
import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.swing.JFrame;
import nl.colorize.multimedialib.renderer.ApplicationData;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.InternetAccess;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.NestedRenderCallback;
import nl.colorize.multimedialib.renderer.RenderCallback;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.Stage;
import nl.colorize.multimedialib.renderer.java2d.AWTInput;
import nl.colorize.multimedialib.renderer.java2d.Java2DGraphicsContext;
import nl.colorize.multimedialib.renderer.java2d.StandardApplicationData;
import nl.colorize.multimedialib.renderer.java2d.StandardInternetAccess;
import nl.colorize.multimedialib.renderer.java2d.StandardMediaLoader;
import nl.colorize.multimedialib.renderer.java2d.WindowOptions;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.PlatformFamily;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.Stopwatch;
import nl.colorize.util.swing.ApplicationMenuListener;
import nl.colorize.util.swing.MacIntegration;
import nl.colorize.util.swing.SwingUtils;
import nl.colorize.util.swing.Utils2D;

public class Java2DRenderer
implements Renderer {
    private NestedRenderCallback callbacks;
    private Canvas canvas;
    private int framerate;
    private Stopwatch syncTimer;
    private long oversleep;
    private StandardMediaLoader mediaLoader;
    private AWTInput inputDevice;
    private WindowOptions options;
    private JFrame window;
    private Java2DGraphicsContext graphicsContext;
    private AtomicBoolean canvasDirty;
    private AtomicBoolean terminated;
    private static final boolean ANTI_ALIASING = true;
    private static final boolean BILINEAR_SCALING = true;
    private static final long MIN_SLEEP_TIME = 1L;
    private static final long MAX_SLEEP_TIME = 50L;
    private static final Logger LOGGER = LogHelper.getLogger(Java2DRenderer.class);

    public Java2DRenderer(Canvas canvas, int framerate, WindowOptions options) {
        Preconditions.checkArgument((framerate >= 1 && framerate <= 120 ? 1 : 0) != 0, (Object)("Invalid framerate: " + framerate));
        SwingUtils.initializeSwing();
        this.callbacks = new NestedRenderCallback();
        this.canvas = canvas;
        this.framerate = framerate;
        this.syncTimer = new Stopwatch();
        this.mediaLoader = new StandardMediaLoader();
        this.options = options;
        this.canvasDirty = new AtomicBoolean(true);
        this.terminated = new AtomicBoolean(false);
    }

    @Override
    public void attach(RenderCallback callback) {
        this.callbacks.add(callback);
    }

    @Override
    public void start() {
        this.window = this.initializeWindow(this.options);
        this.graphicsContext = new Java2DGraphicsContext(this.canvas, this.mediaLoader);
        Thread renderingThread = new Thread(this::runAnimationLoop, "MultimediaLib-RenderingThread");
        renderingThread.start();
    }

    private JFrame initializeWindow(WindowOptions windowOptions) {
        Canvas canvas = this.getCanvas();
        this.window = new JFrame();
        this.window.setDefaultCloseOperation(3);
        this.window.setResizable(true);
        this.window.setIgnoreRepaint(true);
        this.window.setFocusTraversalKeysEnabled(false);
        this.window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Java2DRenderer.this.canvasDirty.set(true);
            }
        });
        this.window.setTitle(windowOptions.getTitle());
        this.window.setIconImage(this.loadIcon(windowOptions));
        this.window.getContentPane().setPreferredSize(new Dimension(canvas.getWidth(), canvas.getHeight()));
        this.window.pack();
        this.window.setLocationRelativeTo(null);
        this.window.setVisible(true);
        if (Platform.isMac()) {
            MacIntegration.setApplicationMenuListener((ApplicationMenuListener)windowOptions.getAppMenuListener(), (boolean)false);
        }
        this.window.createBufferStrategy(2);
        this.initializeInput();
        return this.window;
    }

    private Image loadIcon(WindowOptions windowOptions) {
        if (windowOptions.hasIcon()) {
            return SwingUtils.loadIcon((ResourceFile)windowOptions.getIconFile()).getImage();
        }
        return null;
    }

    private void initializeInput() {
        this.inputDevice = new AWTInput(this.getCanvas());
        this.window.addKeyListener(this.inputDevice);
        this.window.addMouseListener(this.inputDevice);
        this.window.addMouseMotionListener(this.inputDevice);
    }

    @Override
    public GraphicsMode getSupportedGraphicsMode() {
        return GraphicsMode.G2D;
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas;
    }

    @Override
    public Stage getStage() {
        throw new UnsupportedOperationException();
    }

    private void runAnimationLoop() {
        while (!this.terminated.get()) {
            this.syncTimer.tick();
            if (this.canvasDirty.get()) {
                this.canvasDirty.set(false);
                this.prepareCanvas();
            }
            float frameTime = 1.0f / (float)this.framerate;
            this.inputDevice.update(frameTime);
            this.callbacks.update(this, frameTime);
            this.drawFrame();
            Thread.yield();
            long elapsedTime = this.syncTimer.tock();
            this.syncFrame(elapsedTime);
        }
    }

    private void drawFrame() {
        BufferStrategy windowBuffer = this.prepareWindowBuffer();
        Graphics bufferGraphics = windowBuffer.getDrawGraphics();
        Graphics2D g2 = Utils2D.createGraphics((Graphics)bufferGraphics, (boolean)true, (boolean)true);
        this.drawFrame(g2);
        this.blitGraphicsContext(windowBuffer);
        this.graphicsContext.dispose();
    }

    private void drawFrame(Graphics2D g2) {
        this.graphicsContext.bind(g2);
        this.prepareGraphics(g2);
        this.callbacks.render(this, this.graphicsContext);
    }

    private void prepareCanvas() {
        Insets windowInsets = this.window.getInsets();
        int windowWidth = this.window.getWidth() - windowInsets.left - windowInsets.right;
        int windowHeight = this.window.getHeight() - windowInsets.top - windowInsets.bottom;
        Canvas canvas = this.getCanvas();
        canvas.resizeScreen(windowWidth, windowHeight);
        canvas.offsetScreen(windowInsets.left, windowInsets.top);
    }

    private void prepareGraphics(Graphics2D g2) {
        g2.setColor(Color.BLACK);
        g2.fillRect(0, 0, this.window.getWidth(), this.window.getHeight() + 50);
    }

    private void syncFrame(long currentTrameTime) {
        long targetFrameTime = 1000L / (long)this.framerate;
        long sleepTime = targetFrameTime - currentTrameTime - this.oversleep;
        sleepTime = MathUtils.clamp((long)sleepTime, (long)1L, (long)50L);
        try {
            Stopwatch sleepTimer = new Stopwatch();
            Thread.sleep(sleepTime);
            long actualSleepTime = sleepTimer.tock();
            this.oversleep = actualSleepTime - sleepTime;
        }
        catch (InterruptedException e) {
            LOGGER.warning("Frame sync interrupted");
        }
    }

    private BufferStrategy prepareWindowBuffer() {
        return this.window.getBufferStrategy();
    }

    private void blitGraphicsContext(BufferStrategy windowBuffer) {
        if (!windowBuffer.contentsLost()) {
            windowBuffer.show();
            if (Platform.isLinux()) {
                this.window.getToolkit().sync();
            }
        }
    }

    @Override
    public InputDevice getInputDevice() {
        return this.inputDevice;
    }

    @Override
    public MediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    @Override
    public ApplicationData getApplicationData(String appName) {
        return new StandardApplicationData(appName);
    }

    @Override
    public InternetAccess getInternetAccess() {
        return new StandardInternetAccess();
    }

    @Override
    public String takeScreenshot() {
        BufferedImage screenshot = new BufferedImage(this.getCanvas().getWidth(), this.getCanvas().getHeight(), 2);
        Graphics2D g2 = Utils2D.createGraphics((BufferedImage)screenshot, (boolean)true, (boolean)true);
        this.graphicsContext.bind(g2);
        this.prepareGraphics(g2);
        this.callbacks.render(this, this.graphicsContext);
        g2.dispose();
        return Utils2D.toDataURL((BufferedImage)screenshot);
    }

    @Override
    public PlatformFamily getPlatform() {
        return Platform.getPlatformFamily();
    }

    public void terminate() {
        this.terminated.set(true);
        if (this.window != null) {
            this.window.dispose();
        }
    }
}

