/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.PolygonMesh;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.renderer.Audio;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.java2d.AWTImage;
import nl.colorize.multimedialib.renderer.java2d.MP3;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.swing.Utils2D;

public class StandardMediaLoader
implements MediaLoader {
    private Map<TTFont, Font> loadedFonts = new HashMap<TTFont, Font>();

    @Override
    public Image loadImage(FilePointer file) {
        try {
            ResourceFile source = new ResourceFile(file.getPath());
            BufferedImage loadedImage = Utils2D.loadImage((InputStream)source.openStream());
            if (GraphicsEnvironment.isHeadless()) {
                return new AWTImage(loadedImage, file);
            }
            BufferedImage compatibleImage = Utils2D.makeImageCompatible((BufferedImage)loadedImage);
            return new AWTImage(compatibleImage, file);
        }
        catch (IOException e) {
            throw new MediaException("Cannot load image from " + file.getPath(), e);
        }
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        return new MP3(new ResourceFile(file.getPath()));
    }

    @Override
    public TTFont loadFont(FilePointer file, String family, int size, ColorRGB color, boolean bold) {
        TTFont tTFont;
        block8: {
            ResourceFile source = new ResourceFile(file.getPath());
            int style = bold ? 1 : 0;
            InputStream stream = source.openStream();
            try {
                Font awtFont = Font.createFont(0, stream).deriveFont(style, size);
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                env.registerFont(awtFont);
                TTFont font = new TTFont(awtFont.getFamily(), size, color, bold);
                this.loadedFonts.put(font, awtFont);
                tTFont = font;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FontFormatException | IOException e) {
                    throw new MediaException("Cannot load font from " + file.getPath(), e);
                }
            }
            stream.close();
        }
        return tTFont;
    }

    protected Font getFont(TTFont font) {
        Font awtFont = this.loadedFonts.get(font);
        Preconditions.checkArgument((awtFont != null ? 1 : 0) != 0, (Object)("Unknown font: " + font));
        return awtFont;
    }

    @Override
    public String loadText(FilePointer file) {
        ResourceFile resourceFile = new ResourceFile(file.getPath());
        return resourceFile.read(Charsets.UTF_8);
    }

    @Override
    public PolygonMesh loadMesh(FilePointer file) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsResourceFile(FilePointer file) {
        return new ResourceFile(file.getPath()).exists();
    }
}

