/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import nl.colorize.multimedialib.graphics.Align;
import nl.colorize.multimedialib.graphics.AlphaTransform;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsContext2D;
import nl.colorize.multimedialib.renderer.libgdx.GDXImage;
import nl.colorize.multimedialib.renderer.libgdx.GDXMediaLoader;

public class GDXGraphics2D
implements GraphicsContext2D {
    private Canvas canvas;
    private SpriteBatch batch;
    private GDXMediaLoader mediaLoader;
    private static final int CIRCLE_PRECISION = 16;
    private static final Transform DEFAULT_TRANSFORM = new Transform();

    protected GDXGraphics2D(Canvas canvas, SpriteBatch batch, GDXMediaLoader mediaLoader) {
        this.canvas = canvas;
        this.batch = batch;
        this.mediaLoader = mediaLoader;
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas;
    }

    @Override
    public void drawBackground(ColorRGB backgroundColor) {
        Canvas canvas = this.getCanvas();
        Rect background = new Rect(0.0f, 0.0f, canvas.getWidth(), canvas.getHeight());
        this.drawRect(background, backgroundColor, null);
    }

    @Override
    public void drawRect(Rect rect, ColorRGB color, AlphaTransform alpha) {
        Transform transform = new Transform();
        if (alpha != null) {
            transform.setAlpha(alpha.getAlpha());
        }
        Texture colorTexture = this.mediaLoader.getColorTexture(color);
        TextureRegion colorTextureRegion = new TextureRegion(colorTexture, 0, 0, colorTexture.getWidth(), colorTexture.getHeight());
        this.draw(rect.getCenterX(), rect.getCenterY(), rect.getWidth(), rect.getHeight(), color, colorTextureRegion, transform);
    }

    @Override
    public void drawCircle(Circle circle, ColorRGB color, AlphaTransform transform) {
        Polygon polygon = Polygon.createCircle(circle.getCenter(), circle.getRadius(), 16);
        this.drawPolygon(polygon, color, transform);
    }

    @Override
    public void drawPolygon(Polygon polygon, ColorRGB color, AlphaTransform alpha) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawImage(Image image, float x, float y, Transform transform) {
        int width = image.getWidth();
        int height = image.getHeight();
        TextureRegion textureRegion = ((GDXImage)image).getTextureRegion();
        if (transform == null) {
            transform = DEFAULT_TRANSFORM;
        }
        this.draw(x, y, width, height, ColorRGB.WHITE, textureRegion, transform);
    }

    private void draw(float x, float y, float width, float height, ColorRGB color, TextureRegion texture, Transform transform) {
        float canvasX = x - width / 2.0f;
        float canvasY = Math.abs(y - (float)this.getCanvas().getHeight()) - height / 2.0f;
        float originX = width / 2.0f;
        float originY = height / 2.0f;
        this.batch.setColor((float)color.getR() / 255.0f, (float)color.getG() / 255.0f, (float)color.getB() / 255.0f, (float)transform.getAlpha() / 100.0f);
        this.batch.draw(texture, canvasX, canvasY, originX, originY, width, height, (float)transform.getScaleX() / 100.0f, (float)transform.getScaleY() / 100.0f, (float)transform.getRotation());
    }

    @Override
    public void drawText(String text, TTFont font, float x, float y, Align align, AlphaTransform transform) {
        BitmapFont bitmapFont = this.mediaLoader.getBitmapFont(font);
        float canvasY = Math.abs(y - (float)this.getCanvas().getHeight());
        float baseline = (float)font.getSize() * 0.3f;
        bitmapFont.draw((Batch)this.batch, (CharSequence)text, x, canvasY + baseline, 0.0f, this.getTextAlign(align), false);
    }

    private int getTextAlign(Align align) {
        switch (align) {
            case LEFT: {
                return 8;
            }
            case CENTER: {
                return 1;
            }
            case RIGHT: {
                return 16;
            }
        }
        throw new AssertionError();
    }
}

