/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.loader.G3dModelLoader;
import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.utils.BaseJsonReader;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.UBJsonReader;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import nl.colorize.multimedialib.graphics.AnimationInfo;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.PolygonMesh;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.math.MathUtils;
import nl.colorize.multimedialib.renderer.Audio;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.java2d.MP3;
import nl.colorize.multimedialib.renderer.libgdx.GDXImage;
import nl.colorize.util.LogHelper;
import nl.colorize.util.ResourceFile;
import org.teavm.apachecommons.io.Charsets;

public class GDXMediaLoader
implements MediaLoader,
Disposable {
    private G3dModelLoader modelLoader = new G3dModelLoader((BaseJsonReader)new UBJsonReader(), (FileHandleResolver)new InternalFileHandleResolver());
    private List<Disposable> loaded = new ArrayList<Disposable>();
    private Map<PolygonMesh, Model> models = new HashMap<PolygonMesh, Model>();
    private Map<TTFont, BitmapFont> fonts = new HashMap<TTFont, BitmapFont>();
    private Map<ColorRGB, Texture> colorTextureCache = new HashMap<ColorRGB, Texture>();
    private static final int COLOR_TEXTURE_SIZE = 8;
    private static final Logger LOGGER = LogHelper.getLogger(GDXMediaLoader.class);

    @Override
    public Image loadImage(FilePointer file) {
        Texture texture = new Texture(this.getFileHandle(file));
        this.loaded.add((Disposable)texture);
        if (!this.checkTextureDimensions(texture)) {
            LOGGER.warning("Texture dimensions might not be supported by current platform: " + file.getPath() + " (" + texture.getWidth() + "x" + texture.getHeight() + ")");
        }
        return new GDXImage(texture);
    }

    private boolean checkTextureDimensions(Texture texture) {
        return MathUtils.isPowerOfTwo(texture.getWidth()) && MathUtils.isPowerOfTwo(texture.getHeight()) && texture.getWidth() == texture.getHeight();
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        return new MP3(new ResourceFile(file.getPath()));
    }

    public Texture getColorTexture(ColorRGB color) {
        Texture colorTexture = this.colorTextureCache.get(color);
        if (colorTexture == null) {
            colorTexture = this.generateColorTexture(color);
            this.colorTextureCache.put(color, colorTexture);
            this.loaded.add((Disposable)colorTexture);
        }
        return colorTexture;
    }

    private Texture generateColorTexture(ColorRGB color) {
        Pixmap pixelData = new Pixmap(8, 8, Pixmap.Format.RGBA8888);
        pixelData.setColor(this.toColor(color));
        pixelData.fillRectangle(0, 0, 8, 8);
        return new Texture(pixelData);
    }

    @Override
    public TTFont loadFont(FilePointer file, String family, int size, ColorRGB color, boolean bold) {
        FreeTypeFontGenerator.FreeTypeFontParameter config = new FreeTypeFontGenerator.FreeTypeFontParameter();
        config.size = size;
        config.color = this.toColor(color);
        FreeTypeFontGenerator fontGenerator = new FreeTypeFontGenerator(this.getFileHandle(file));
        BitmapFont bitmapFont = fontGenerator.generateFont(config);
        fontGenerator.dispose();
        TTFont font = new TTFont(family, size, color, bold);
        this.loaded.add((Disposable)bitmapFont);
        this.fonts.put(font, bitmapFont);
        return font;
    }

    protected BitmapFont getBitmapFont(TTFont font) {
        BitmapFont bitmapFont = this.fonts.get(font);
        Preconditions.checkState((bitmapFont != null ? 1 : 0) != 0, (Object)("Font not loaded: " + font));
        return bitmapFont;
    }

    @Override
    public String loadText(FilePointer file) {
        ResourceFile resourceFile = new ResourceFile(file.getPath());
        return resourceFile.read(Charsets.UTF_8);
    }

    @Override
    public PolygonMesh loadMesh(FilePointer file) {
        Preconditions.checkArgument((boolean)file.getPath().endsWith(".fbx"), (Object)"Only .fbx files are sypported, they will be converted to .g3db during loading");
        String path = file.getPath().substring(0, file.getPath().length() - 4) + ".g3db";
        Model model = this.modelLoader.loadModel(this.getFileHandle(path));
        List<AnimationInfo> animations = this.parseModelAnimations(model);
        PolygonMesh mesh = new PolygonMesh(file.getPath(), animations);
        this.loaded.add((Disposable)model);
        this.models.put(mesh, model);
        return mesh;
    }

    private List<AnimationInfo> parseModelAnimations(Model model) {
        ArrayList<AnimationInfo> animations = new ArrayList<AnimationInfo>();
        for (Animation anim : model.animations) {
            animations.add(new AnimationInfo(anim.id, anim.duration));
        }
        return animations;
    }

    protected PolygonMesh registerMesh(String name, Model modelData) {
        PolygonMesh mesh = new PolygonMesh(name, Collections.emptyList());
        this.loaded.add((Disposable)modelData);
        this.models.put(mesh, modelData);
        return mesh;
    }

    protected Model getModelData(PolygonMesh mesh) {
        Model modelData = this.models.get(mesh);
        Preconditions.checkState((modelData != null ? 1 : 0) != 0, (Object)("Model data not loaded: " + mesh));
        return modelData;
    }

    @Override
    public boolean containsResourceFile(FilePointer file) {
        return new ResourceFile(file.getPath()).exists();
    }

    private FileHandle getFileHandle(FilePointer file) {
        return this.getFileHandle(file.getPath());
    }

    private FileHandle getFileHandle(String path) {
        return Gdx.files.internal(path);
    }

    public Color toColor(ColorRGB color) {
        return new Color((float)color.getR() / 255.0f, (float)color.getG() / 255.0f, (float)color.getB() / 255.0f, 1.0f);
    }

    public void dispose() {
        for (Disposable disposable : this.loaded) {
            disposable.dispose();
        }
        this.loaded.clear();
        this.models.clear();
        this.fonts.clear();
        this.colorTextureCache.clear();
    }
}

