/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nl.colorize.multimedialib.renderer.Updatable;
import nl.colorize.multimedialib.scene.State;

public class StateMachine<T extends State>
implements Updatable {
    private Map<String, T> possibleStates = new HashMap<String, T>();
    private T activeState = null;
    private float activeStateTime = 0.0f;
    private float activeStateDuration = 0.0f;

    public void register(T state) {
        String stateName = state.getName();
        Preconditions.checkArgument((stateName.length() > 0 ? 1 : 0) != 0, (Object)("Invalid state name: " + stateName));
        Preconditions.checkArgument((!this.possibleStates.containsKey(stateName) ? 1 : 0) != 0, (Object)("State machine already contains state with name " + stateName));
        this.possibleStates.put(stateName, state);
        if (this.possibleStates.size() == 1) {
            this.activeState = state;
            this.activeStateTime = 0.0f;
            this.activeStateDuration = state.getDuration();
        }
    }

    public boolean changeState(T requestedState) {
        float duration = requestedState.getDuration();
        return this.changeState(requestedState, duration);
    }

    public boolean changeState(T requestedState, float duration) {
        if (requestedState.equals(this.activeState)) {
            return false;
        }
        if (this.activeState != null && !this.activeState.isInterruptable()) {
            return false;
        }
        this.activeState = requestedState;
        this.activeStateTime = 0.0f;
        this.activeStateDuration = duration;
        if (!this.possibleStates.containsValue(requestedState)) {
            this.possibleStates.put(requestedState.getName(), requestedState);
        }
        return true;
    }

    @Override
    public void update(float deltaTime) {
        Preconditions.checkState((this.activeState != null ? 1 : 0) != 0, (Object)"State machine does not have an active state");
        this.activeStateTime += deltaTime;
        if (this.activeStateDuration > 0.0f && this.activeStateTime >= this.activeStateDuration) {
            this.changeState(this.activeState.getNext());
        }
    }

    public void resetActiveState() {
        this.activeStateTime = 0.0f;
    }

    public T getActiveState() {
        Preconditions.checkState((this.activeState != null ? 1 : 0) != 0, (Object)"State machine has not yet been set to an active state");
        return this.activeState;
    }

    public String getActiveStateName() {
        return this.getActiveState().getName();
    }

    public float getActiveStateTime() {
        return this.activeStateTime;
    }

    public float getActiveStateDuration() {
        return this.activeStateTime;
    }

    public Set<T> getPossibleStates() {
        return ImmutableSet.copyOf(this.possibleStates.values());
    }

    public T getPossibleState(String name) {
        Preconditions.checkArgument((boolean)this.hasState(name), (Object)("Unknown state: " + name));
        return (T)((State)this.possibleStates.get(name));
    }

    public boolean hasState(String name) {
        return this.possibleStates.containsKey(name);
    }

    public boolean hasState(State state) {
        return this.hasState(state.getName());
    }
}

