/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import com.google.common.base.Preconditions;

public final class ColorRGB {
    private int r;
    private int g;
    private int b;
    public static final ColorRGB BLACK = new ColorRGB(0, 0, 0);
    public static final ColorRGB WHITE = new ColorRGB(255, 255, 255);
    public static final ColorRGB GRAY = new ColorRGB(127, 127, 127);
    public static final ColorRGB RED = new ColorRGB(255, 0, 0);
    public static final ColorRGB GREEN = new ColorRGB(0, 255, 0);
    public static final ColorRGB BLUE = new ColorRGB(0, 0, 255);
    public static final ColorRGB YELLOW = new ColorRGB(255, 255, 0);

    public ColorRGB(int r, int g, int b) {
        this.r = ColorRGB.parseColorComponent(r);
        this.g = ColorRGB.parseColorComponent(g);
        this.b = ColorRGB.parseColorComponent(b);
    }

    public ColorRGB(int rgba) {
        this.r = rgba >> 16 & 0xFF;
        this.g = rgba >> 8 & 0xFF;
        this.b = rgba & 0xFF;
    }

    public int getR() {
        return this.r;
    }

    public int getG() {
        return this.g;
    }

    public int getB() {
        return this.b;
    }

    public int getRGB() {
        int rgb = this.r;
        rgb = (rgb << 8) + this.g;
        rgb = (rgb << 8) + this.b;
        return rgb;
    }

    public boolean equals(Object o) {
        if (o instanceof ColorRGB) {
            ColorRGB other = (ColorRGB)o;
            return this.r == other.r && this.g == other.g && this.b == other.b;
        }
        return false;
    }

    public int hashCode() {
        return 0 | (this.r & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.b & 0xFF;
    }

    public String toString() {
        return "ColorRGB(" + this.r + ", " + this.g + ", " + this.b + ")";
    }

    public String toHex() {
        StringBuilder hex = new StringBuilder(7);
        hex.append('#');
        hex.append(this.toHex(this.r));
        hex.append(this.toHex(this.g));
        hex.append(this.toHex(this.b));
        return hex.toString().toUpperCase();
    }

    private String toHex(int component) {
        String str = Integer.toHexString(component);
        return str.length() > 1 ? str : "0" + str;
    }

    public static ColorRGB parseHex(String hex) {
        if (hex.length() != 6 && hex.length() != 7) {
            throw new IllegalArgumentException("Invalid hexadecimal color: " + hex);
        }
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        return new ColorRGB(Integer.parseInt(hex.substring(0, 2), 16), Integer.parseInt(hex.substring(2, 4), 16), Integer.parseInt(hex.substring(4, 6), 16));
    }

    private static int parseColorComponent(int colorComponent) {
        Preconditions.checkArgument((colorComponent >= 0 && colorComponent <= 255 ? 1 : 0) != 0, (Object)("Color component out of range: " + colorComponent));
        return colorComponent;
    }
}

