/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import nl.colorize.multimedialib.graphics.AnimationInfo;
import nl.colorize.multimedialib.graphics.PolygonModel;

public final class PolygonMesh {
    private UUID id;
    private String name;
    private Map<String, AnimationInfo> animations;

    public PolygonMesh(UUID id, String name, List<AnimationInfo> animations) {
        Preconditions.checkArgument((name.length() >= 1 ? 1 : 0) != 0, (Object)"Mesh name required");
        this.id = id;
        this.name = name;
        this.animations = new HashMap<String, AnimationInfo>();
        for (AnimationInfo animation : animations) {
            this.addAnimation(animation);
        }
    }

    public PolygonMesh(String name, List<AnimationInfo> animations) {
        this(UUID.randomUUID(), name, animations);
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void addAnimation(AnimationInfo anim) {
        Preconditions.checkArgument((!this.animations.containsKey(anim.getName()) ? 1 : 0) != 0, (Object)("Animation with the same name already exists: " + anim.getName()));
        this.animations.put(anim.getName(), anim);
    }

    public AnimationInfo getAnimation(String name) {
        AnimationInfo animation = this.animations.get(name);
        Preconditions.checkArgument((animation != null ? 1 : 0) != 0, (Object)("No such animation: " + name));
        return animation;
    }

    public Set<AnimationInfo> getAnimations() {
        return ImmutableSet.copyOf(this.animations.values());
    }

    public PolygonModel createModel() {
        return new PolygonModel(this);
    }

    public boolean equals(Object o) {
        if (o instanceof PolygonMesh) {
            PolygonMesh other = (PolygonMesh)o;
            return this.id.equals(other.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

