/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import com.google.common.base.Preconditions;
import java.util.UUID;
import nl.colorize.multimedialib.graphics.AnimationInfo;
import nl.colorize.multimedialib.graphics.PolygonMesh;
import nl.colorize.multimedialib.math.Point3D;

public final class PolygonModel {
    private UUID id;
    private PolygonMesh mesh;
    private Point3D position;
    private float rotationX;
    private float rotationY;
    private float rotationZ;
    private float rotationAmount;
    private float scaleX;
    private float scaleY;
    private float scaleZ;

    protected PolygonModel(UUID id, PolygonMesh mesh) {
        this.id = id;
        this.mesh = mesh;
        this.position = new Point3D(0.0f, 0.0f, 0.0f);
        this.rotationX = 0.0f;
        this.rotationY = 0.0f;
        this.rotationZ = 0.0f;
        this.rotationAmount = 0.0f;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.scaleZ = 1.0f;
    }

    protected PolygonModel(PolygonMesh mesh) {
        this(UUID.randomUUID(), mesh);
    }

    public UUID getId() {
        return this.id;
    }

    public PolygonMesh getMesh() {
        return this.mesh;
    }

    public AnimationInfo getAnimation(String name) {
        return this.mesh.getAnimation(name);
    }

    public void setPosition(Point3D p) {
        this.position.set(p);
    }

    public void setPosition(float x, float y, float z) {
        this.position.set(x, y, z);
    }

    public Point3D getPosition() {
        return this.position;
    }

    public void setRotation(float x, float y, float z, float amount) {
        this.rotationX = x;
        this.rotationY = y;
        this.rotationZ = z;
        this.rotationAmount = amount;
    }

    public float getRotationX() {
        return this.rotationX;
    }

    public float getRotationY() {
        return this.rotationY;
    }

    public float getRotationZ() {
        return this.rotationZ;
    }

    public float getRotationAmount() {
        return this.rotationAmount;
    }

    public void setScale(float scaleX, float scaleY, float scaleZ) {
        Preconditions.checkArgument((scaleX > 0.0f ? 1 : 0) != 0, (Object)("Invalid X scale: " + scaleX));
        Preconditions.checkArgument((scaleY > 0.0f ? 1 : 0) != 0, (Object)("Invalid Y scale: " + scaleY));
        Preconditions.checkArgument((scaleZ > 0.0f ? 1 : 0) != 0, (Object)("Invalid Z scale: " + scaleZ));
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
    }

    public void setScale(float scale) {
        this.setScale(scale, scale, scale);
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public float getScaleZ() {
        return this.scaleZ;
    }

    public boolean equals(Object o) {
        if (o instanceof PolygonModel) {
            PolygonModel other = (PolygonModel)o;
            return this.id.equals(other.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.mesh.getName() + " (" + this.id + ")";
    }
}

