/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.graphics.ColorRGB;

public final class TTFont {
    private String family;
    private int size;
    private ColorRGB color;
    private boolean bold;

    public TTFont(String family, int size, ColorRGB color, boolean bold) {
        Preconditions.checkArgument((family.length() >= 1 ? 1 : 0) != 0, (Object)("Invalid font family: " + family));
        Preconditions.checkArgument((size >= 4 ? 1 : 0) != 0, (Object)("Invalid font size: " + size));
        this.family = family;
        this.size = size;
        this.color = color;
        this.bold = bold;
    }

    public String getFamily() {
        return this.family;
    }

    public int getSize() {
        return this.size;
    }

    public ColorRGB getColor() {
        return this.color;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean equals(Object o) {
        if (o instanceof TTFont) {
            TTFont other = (TTFont)o;
            return this.family.equals(other.family) && this.size == other.size && this.color.equals(other.color) && this.bold == other.bold;
        }
        return false;
    }

    public int hashCode() {
        return this.family.hashCode();
    }

    public String toString() {
        return this.size + "px " + this.family + " (" + this.color + ")";
    }
}

