/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.SpriteSheet;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.MediaLoader;

public class VirtualSpriteSheet
extends SpriteSheet {
    private MediaLoader mediaLoader;
    private String prefix;

    public VirtualSpriteSheet(MediaLoader mediaLoader, String prefix) {
        super(null);
        Preconditions.checkArgument((!prefix.startsWith("/") ? 1 : 0) != 0, (Object)("Invalid prefix: " + prefix));
        Preconditions.checkArgument((!prefix.contains("..") ? 1 : 0) != 0, (Object)("Invalid prefix: " + prefix));
        this.mediaLoader = mediaLoader;
        this.prefix = prefix;
    }

    public VirtualSpriteSheet(MediaLoader mediaLoader) {
        this(mediaLoader, "");
    }

    @Override
    public Image get(String name) {
        FilePointer imagePath = new FilePointer(this.prefix + name);
        return this.mediaLoader.loadImage(imagePath);
    }

    @Override
    protected boolean isValidRegion(Rect region) {
        return true;
    }

    @Override
    public Rect getRegion(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Image getImage() {
        throw new UnsupportedOperationException();
    }
}

