/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

public class Point3D {
    private float x;
    private float y;
    private float z;

    public Point3D(float x, float y, float z) {
        this.set(x, y, z);
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(Point3D p) {
        this.set(p.getX(), p.getY(), p.getZ());
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getX() {
        return this.x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getY() {
        return this.y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public float getZ() {
        return this.z;
    }

    public void add(float deltaX, float deltaY, float deltaZ) {
        this.x += deltaX;
        this.y += deltaY;
        this.z += deltaZ;
    }

    public Point3D normalize() {
        float length = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        return new Point3D(this.x / length, this.y / length, this.z / length);
    }

    public Point3D copy() {
        return new Point3D(this.x, this.y, this.z);
    }

    public String toString() {
        return "(" + Math.round(this.x) + ", " + Math.round(this.y) + ", " + Math.round(this.z) + ")";
    }
}

