/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Random;

public class RandomGenerator {
    private static Random generator = new Random();

    private RandomGenerator() {
    }

    public static int getInt(int min, int max) {
        Preconditions.checkArgument((max > min ? 1 : 0) != 0, (Object)("Invalid range: " + min + " - " + max));
        return min + generator.nextInt(max - min);
    }

    public static float getFloat(float min, float max) {
        Preconditions.checkArgument((max > min ? 1 : 0) != 0, (Object)("Invalid range: " + min + " - " + max));
        return min + generator.nextFloat() * (max - min);
    }

    public static boolean chance(float n) {
        Preconditions.checkArgument((n >= 0.0f && n <= 1.0f ? 1 : 0) != 0, (Object)("Number out of range: " + n));
        float value = generator.nextFloat();
        return n <= value;
    }

    public static <T> T pick(List<T> elements) {
        Preconditions.checkArgument((!elements.isEmpty() ? 1 : 0) != 0, (Object)"Cannot pick from empty list");
        int index = RandomGenerator.getInt(0, elements.size());
        return elements.get(index);
    }
}

