/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import java.util.Objects;
import nl.colorize.multimedialib.math.Point2D;

public class Vector {
    private float direction;
    private float magnitude;
    public static final float EPSILON = 0.001f;

    public Vector(float direction, float magnitude) {
        this.direction = direction;
        this.magnitude = magnitude;
    }

    public void setDirection(float direction) {
        this.direction = direction;
    }

    public float getDirection() {
        return this.direction;
    }

    public void setMagnitude(float magnitude) {
        this.magnitude = magnitude;
    }

    public float getMagnitude() {
        return this.magnitude;
    }

    public float getX() {
        return this.magnitude * (float)Math.cos(Math.toRadians(this.direction));
    }

    public float getY() {
        return this.magnitude * (float)Math.sin(Math.toRadians(this.direction));
    }

    public Point2D toPoint() {
        return new Point2D(this.getX(), this.getY());
    }

    public Vector copy() {
        return new Vector(this.direction, this.magnitude);
    }

    public boolean equals(Object o) {
        if (o instanceof Vector) {
            Vector other = (Vector)o;
            return Math.abs(this.direction - other.direction) < 0.001f && Math.abs(this.magnitude - other.magnitude) < 0.001f;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.direction), Float.valueOf(this.magnitude));
    }

    public String toString() {
        return String.format("Vector2D(direction=%.0f, magnitude=%.1f", Float.valueOf(this.direction), Float.valueOf(this.magnitude));
    }
}

