/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.Rect;

public class GDXImage
implements Image {
    private Texture texture;
    private TextureRegion textureRegion;
    private Pixmap textureData;
    private Rect bounds;

    protected GDXImage(Texture texture, Rect bounds) {
        float u1 = bounds.getX() / (float)texture.getWidth();
        float v1 = bounds.getY() / (float)texture.getHeight();
        float u2 = bounds.getEndX() / (float)texture.getWidth();
        float v2 = bounds.getEndY() / (float)texture.getHeight();
        this.texture = texture;
        this.textureRegion = new TextureRegion(texture, u1, v1, u2, v2);
        this.bounds = bounds;
    }

    protected GDXImage(Texture texture) {
        this(texture, new Rect(0.0f, 0.0f, texture.getWidth(), texture.getHeight()));
    }

    public Texture getTexture() {
        return this.texture;
    }

    public TextureRegion getTextureRegion() {
        return this.textureRegion;
    }

    @Override
    public Rect getRegion() {
        return this.bounds;
    }

    @Override
    public Image extractRegion(Rect region) {
        return new GDXImage(this.texture, region);
    }

    private void loadTextureData() {
        if (this.textureData == null) {
            TextureData data = this.texture.getTextureData();
            data.prepare();
            this.textureData = data.consumePixmap();
        }
    }

    @Override
    public ColorRGB getColor(int x, int y) {
        this.loadTextureData();
        int rgba = this.textureData.getPixel(x, y);
        return new ColorRGB(rgba);
    }

    @Override
    public int getAlpha(int x, int y) {
        this.loadTextureData();
        int rgba = this.textureData.getPixel(x, y);
        int alpha = rgba >> 24 & 0xFF;
        return Math.round((float)alpha / 2.55f);
    }
}

