/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.utils.CameraInputController;
import com.badlogic.gdx.utils.ScreenUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import nl.colorize.multimedialib.renderer.ApplicationData;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.InternetAccess;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.NestedRenderCallback;
import nl.colorize.multimedialib.renderer.RenderCallback;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.Stage;
import nl.colorize.multimedialib.renderer.java2d.StandardApplicationData;
import nl.colorize.multimedialib.renderer.java2d.StandardInternetAccess;
import nl.colorize.multimedialib.renderer.java2d.WindowOptions;
import nl.colorize.multimedialib.renderer.libgdx.GDXApplicationData;
import nl.colorize.multimedialib.renderer.libgdx.GDXGraphics2D;
import nl.colorize.multimedialib.renderer.libgdx.GDXInput;
import nl.colorize.multimedialib.renderer.libgdx.GDXMediaLoader;
import nl.colorize.multimedialib.renderer.libgdx.GDXStage;
import nl.colorize.util.LoadUtils;
import nl.colorize.util.Platform;
import nl.colorize.util.PlatformFamily;
import nl.colorize.util.swing.Utils2D;

public class GDXRenderer
implements Renderer,
ApplicationListener {
    private NestedRenderCallback callbacks;
    private Canvas canvas;
    private GDXStage stage;
    private GDXInput input;
    private GDXMediaLoader mediaLoader;
    private int framerate;
    private WindowOptions windowOptions;
    private boolean freeCamera;
    private ModelBatch modelBatch;
    private SpriteBatch spriteBatch;
    private CameraInputController freeCameraController;
    private static final List<Integer> SUPPORTED_FRAMERATES = ImmutableList.of((Object)20, (Object)25, (Object)30, (Object)60);

    public GDXRenderer(Canvas canvas, int framerate, WindowOptions options) {
        Preconditions.checkArgument((boolean)SUPPORTED_FRAMERATES.contains(framerate), (Object)("Framerate is not supported: " + framerate));
        this.callbacks = new NestedRenderCallback();
        this.canvas = canvas;
        this.framerate = framerate;
        this.windowOptions = options;
        this.freeCamera = false;
    }

    @Override
    public void attach(RenderCallback callback) {
        this.callbacks.add(callback);
    }

    @Override
    public void start() {
        Lwjgl3ApplicationConfiguration config = new Lwjgl3ApplicationConfiguration();
        config.setWindowedMode(this.canvas.getWidth(), this.canvas.getHeight());
        config.setDecorated(true);
        config.setIdleFPS(this.framerate);
        config.setTitle(this.windowOptions.getTitle());
        if (this.windowOptions.hasIcon()) {
            config.setWindowIcon(Files.FileType.Internal, new String[]{this.windowOptions.getIconFile().getPath()});
        }
        new Lwjgl3Application((ApplicationListener)this, config);
    }

    public void create() {
        this.mediaLoader = new GDXMediaLoader();
        this.stage = new GDXStage(this.mediaLoader);
        this.input = new GDXInput();
        this.resize(this.getCanvas().getWidth(), this.getCanvas().getHeight());
        this.modelBatch = new ModelBatch();
        this.spriteBatch = new SpriteBatch();
        if (this.freeCamera) {
            this.freeCameraController = new CameraInputController((Camera)this.stage.getCamera());
            Gdx.input.setInputProcessor((InputProcessor)this.freeCameraController);
        }
    }

    public void dispose() {
        this.modelBatch.dispose();
        this.spriteBatch.dispose();
        this.mediaLoader.dispose();
    }

    public void resize(int width, int height) {
        this.getCanvas().resizeScreen(width, height);
    }

    public void pause() {
    }

    public void resume() {
    }

    public void render() {
        Gdx.gl.glViewport(0, 0, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16640);
        float frameTime = 1.0f / (float)this.framerate;
        this.input.update(frameTime);
        this.callbacks.update(this, frameTime);
        this.stage.update(frameTime);
        if (this.freeCamera) {
            this.freeCameraController.update();
        }
        this.modelBatch.begin((Camera)this.stage.getCamera());
        this.modelBatch.render(this.stage.getModelDisplayList(), this.stage.getEnvironment());
        this.modelBatch.end();
        GDXGraphics2D graphicsContext2D = new GDXGraphics2D(this.canvas, this.spriteBatch, this.mediaLoader);
        this.spriteBatch.begin();
        this.callbacks.render(this, graphicsContext2D);
        this.spriteBatch.end();
    }

    @Override
    public GraphicsMode getSupportedGraphicsMode() {
        return GraphicsMode.ALL;
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas;
    }

    @Override
    public Stage getStage() {
        return this.stage;
    }

    @Override
    public InputDevice getInputDevice() {
        return this.input;
    }

    @Override
    public MediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    @Override
    public ApplicationData getApplicationData(String appName) {
        if (Platform.isWindows() || Platform.isMac()) {
            return new StandardApplicationData(appName);
        }
        return new GDXApplicationData(appName);
    }

    @Override
    public InternetAccess getInternetAccess() {
        return new StandardInternetAccess();
    }

    @Override
    public String takeScreenshot() {
        Pixmap screenshot = ScreenUtils.getFrameBufferPixmap((int)0, (int)0, (int)Gdx.graphics.getWidth(), (int)Gdx.graphics.getHeight());
        File tempFile = LoadUtils.getTempFile((String)".png");
        PixmapIO.writePNG((FileHandle)Gdx.files.external(tempFile.getAbsolutePath()), (Pixmap)screenshot, (int)-1, (boolean)true);
        screenshot.dispose();
        try {
            BufferedImage screenshotImage = Utils2D.loadImage((File)tempFile);
            return Utils2D.toDataURL((BufferedImage)screenshotImage);
        }
        catch (IOException e) {
            throw new MediaException("Screenshot failed", e);
        }
    }

    @Override
    public PlatformFamily getPlatform() {
        return Platform.getPlatformFamily();
    }

    public void enableFreeCamera() {
        this.freeCamera = true;
    }
}

