/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.renderer.InternetAccess;
import nl.colorize.multimedialib.renderer.WebSocketConnection;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.WebSocketCallback;
import nl.colorize.util.Promise;
import nl.colorize.util.http.Headers;
import nl.colorize.util.http.PostData;

public class TeaInternetAccess
implements InternetAccess {
    @Override
    public Promise<String> get(String url, Headers headers) {
        return new Promise(promise -> {
            String[] headersArray = this.serializeHeaders(headers);
            Browser.sendGetRequest(url, headersArray, arg_0 -> ((Promise)promise).resolve(arg_0));
        });
    }

    @Override
    public Promise<String> post(String url, Headers headers, PostData data) {
        return new Promise(promise -> {
            String[] headersArray = this.serializeHeaders(headers);
            String body = data.encode(StandardCharsets.UTF_8);
            Browser.sendPostRequest(url, headersArray, body, arg_0 -> ((Promise)promise).resolve(arg_0));
        });
    }

    private String[] serializeHeaders(Headers headers) {
        ArrayList<String> entries = new ArrayList<String>();
        for (String name : headers.getNames()) {
            for (String value : headers.getValues(name)) {
                entries.add(name);
                entries.add(value);
            }
        }
        return entries.toArray(new String[0]);
    }

    @Override
    public boolean isWebSocketSupported() {
        return Browser.isWebSocketSupported();
    }

    @Override
    public WebSocketConnection connectWebSocket(String uri) {
        BrowserWebSocketConnection connection = new BrowserWebSocketConnection();
        Browser.connectWebSocket(uri, connection);
        return connection;
    }

    private static class BrowserWebSocketConnection
    implements WebSocketConnection,
    WebSocketCallback {
        private boolean open = false;
        private List<String> sendBuffer = new ArrayList<String>();
        private List<String> receiveBuffer = new ArrayList<String>();

        private BrowserWebSocketConnection() {
        }

        @Override
        public void onMessage(String message) {
            if (message.equals("__open")) {
                this.open = true;
                this.sendBuffer.forEach(this::send);
                this.sendBuffer.clear();
            } else {
                this.receiveBuffer.add(message);
            }
        }

        @Override
        public void send(String message) {
            if (this.open) {
                Browser.sendWebSocket(message);
            } else {
                this.sendBuffer.add(message);
            }
        }

        @Override
        public List<String> flushReceivedMessages() {
            ImmutableList received = ImmutableList.copyOf(this.receiveBuffer);
            this.receiveBuffer.clear();
            return received;
        }

        @Override
        public void close() {
            this.open = false;
            Browser.closeWebSocket();
        }
    }
}

