/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.util.HashMap;
import java.util.Map;
import nl.colorize.multimedialib.graphics.Animation;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.PolygonMesh;
import nl.colorize.multimedialib.graphics.Sprite;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.renderer.Audio;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.MediaLoader;

public class MediaManager {
    private MediaLoader mediaLoader;
    private Map<String, Object> assets;

    public MediaManager(MediaLoader mediaLoader) {
        this.mediaLoader = mediaLoader;
        this.assets = new HashMap<String, Object>();
    }

    private <T> T store(String key, T asset) {
        if (this.assets.containsKey(key)) {
            throw new MediaException("Multiple media assets with the same key: " + key);
        }
        this.assets.put(key, asset);
        return asset;
    }

    public Image loadImage(String key, FilePointer file) {
        return this.store(key, this.mediaLoader.loadImage(file));
    }

    public Audio loadAudio(String key, FilePointer file) {
        return this.store(key, this.mediaLoader.loadAudio(file));
    }

    public TTFont loadFont(String key, FilePointer file, String family, int size, ColorRGB color, boolean bold) {
        return this.store(key, this.mediaLoader.loadFont(file, family, size, color, bold));
    }

    public PolygonMesh loadMesh(String key, FilePointer file) {
        return this.store(key, this.mediaLoader.loadMesh(file));
    }

    public String loadText(String key, FilePointer file) {
        return this.store(key, this.mediaLoader.loadText(file));
    }

    public void storeAnimation(String key, Animation anim) {
        this.store(key, anim);
    }

    public void storeSprite(String key, Sprite sprite) {
        this.store(key, sprite);
    }

    private Object get(String key) {
        Object asset = this.assets.get(key);
        if (asset == null) {
            throw new MediaException("Unknown media asset: " + key);
        }
        return asset;
    }

    public Image getImage(String key) {
        return (Image)this.get(key);
    }

    public Animation getAnimation(String key) {
        return (Animation)this.get(key);
    }

    public Sprite getSprite(String key) {
        Sprite sprite = (Sprite)this.get(key);
        return sprite.copy();
    }

    public Audio getAudio(String key) {
        return (Audio)this.get(key);
    }

    public TTFont getFont(String key) {
        return (TTFont)this.get(key);
    }

    public PolygonMesh getMesh(String key) {
        return (PolygonMesh)this.get(key);
    }

    public String getText(String key) {
        return (String)this.get(key);
    }

    public void unload(String key) {
        this.assets.remove(key);
    }

    public void unloadAll(String key) {
        this.assets.clear();
    }
}

