/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.collect.ImmutableList;
import java.util.List;
import nl.colorize.multimedialib.renderer.Drawable;
import nl.colorize.multimedialib.renderer.GraphicsContext2D;
import nl.colorize.multimedialib.renderer.Updatable;
import nl.colorize.multimedialib.scene.Application;
import nl.colorize.multimedialib.scene.Scene;

public class SceneWrapper
implements Scene {
    private Updatable updateCallback;
    private List<Drawable> graphics;

    private SceneWrapper(Updatable updateCallback, Drawable ... graphics) {
        this.updateCallback = updateCallback;
        this.graphics = ImmutableList.copyOf((Object[])graphics);
    }

    @Override
    public void start(Application app) {
    }

    @Override
    public void update(Application app, float deltaTime) {
        if (this.updateCallback != null) {
            this.updateCallback.update(deltaTime);
        }
    }

    @Override
    public void render(Application app, GraphicsContext2D graphicsContext) {
        for (Drawable graphic : this.graphics) {
            graphic.render(graphicsContext);
        }
    }

    public static Scene wrap(Updatable updateCallback, Drawable ... graphics) {
        return new SceneWrapper(updateCallback, graphics);
    }
}

