/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.renderer.Updatable;

public class Timer
implements Updatable {
    private float position;
    private float duration;
    private List<Runnable> actions = new ArrayList<Runnable>();

    public Timer(float duration) {
        this.reset(duration);
    }

    @Override
    public void update(float deltaTime) {
        if (this.isCompleted()) {
            return;
        }
        this.position = Math.min(this.position + deltaTime, this.duration);
        if (this.isCompleted()) {
            for (Runnable action : this.actions) {
                action.run();
            }
        }
    }

    public float getTime() {
        return this.position;
    }

    public float getDuration() {
        return this.duration;
    }

    public boolean isCompleted() {
        return this.position >= this.duration;
    }

    public float getRatio() {
        return this.position / this.duration;
    }

    public void reset() {
        this.position = 0.0f;
    }

    public void reset(float duration) {
        Preconditions.checkArgument((duration >= 0.0f ? 1 : 0) != 0, (Object)("Invalid duration: " + duration));
        this.position = 0.0f;
        this.duration = duration;
    }

    public void attach(Runnable action) {
        this.actions.add(action);
    }

    public static Timer indefinite() {
        return new Timer(Float.MAX_VALUE);
    }
}

