/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.multimedialib.tool.CommandLineTool;
import nl.colorize.util.FileUtils;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.swing.Utils2D;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class AppleIconTool
extends CommandLineTool {
    @Argument(index=0, metaVar="image", required=true)
    public File inputImageFile;
    @Argument(index=1, metaVar="location", required=true)
    public File location;
    @Option(name="-platform", required=true, usage="Either 'mac' or 'ios'")
    public String platform = "mac";
    private static final List<Integer> MAC_VARIANTS = ImmutableList.of((Object)16, (Object)32, (Object)128, (Object)256, (Object)512);
    private static final List<Integer> IOS_VARIANTS = ImmutableList.of((Object)60, (Object)76, (Object)1024);
    private static final Logger LOGGER = LogHelper.getLogger(AppleIconTool.class);

    public static void main(String[] args) {
        AppleIconTool tool = new AppleIconTool();
        tool.start(args);
    }

    @Override
    public void run() {
        try {
            if (!Platform.isMac()) {
                LOGGER.warning("Creating ICNS icons is only possible on Mac OS");
                return;
            }
            BufferedImage sourceImage = this.loadImage(this.inputImageFile);
            List<Icon> iconSet = this.createIconSet(sourceImage, this.getIconVariants());
            switch (this.platform) {
                case "mac": {
                    this.createICNS(iconSet);
                    break;
                }
                case "ios": {
                    this.createIOS(iconSet);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported platform: " + this.platform);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to create ICNS icon", e);
        }
    }

    private List<Integer> getIconVariants() {
        switch (this.platform) {
            case "mac": {
                return MAC_VARIANTS;
            }
            case "ios": {
                return IOS_VARIANTS;
            }
        }
        throw new IllegalArgumentException("Unsupported platform: " + this.platform);
    }

    private BufferedImage loadImage(File sourceImageFile) {
        try {
            BufferedImage image = Utils2D.loadImage((File)sourceImageFile);
            if (image.getWidth() != image.getHeight()) {
                throw new RuntimeException("Image must be square to be used as icon");
            }
            return image;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load image: " + sourceImageFile.getAbsolutePath());
        }
    }

    private List<Icon> createIconSet(BufferedImage source, List<Integer> variants) {
        ArrayList<Icon> iconSet = new ArrayList<Icon>();
        for (int variant : variants) {
            iconSet.add(new Icon(this.getIconName(variant, 1), 1, this.scaleIconImage(source, variant)));
            if (variant < 1024) {
                iconSet.add(new Icon(this.getIconName(variant, 2), 2, this.scaleIconImage(source, 2 * variant)));
            }
            if (variant != 60) continue;
            iconSet.add(new Icon(this.getIconName(variant, 3), 3, this.scaleIconImage(source, 3 * variant)));
        }
        return iconSet;
    }

    private String getIconName(int size, int factor) {
        String separator;
        String string = separator = this.platform.equals("mac") ? "_" : "-";
        if (factor == 1) {
            return "icon" + separator + size + "x" + size + ".png";
        }
        return "icon" + separator + size + "x" + size + "@" + factor + "x.png";
    }

    private BufferedImage scaleIconImage(BufferedImage sourceImage, int size) {
        if (sourceImage.getWidth() == size && sourceImage.getHeight() == size) {
            return sourceImage;
        }
        return Utils2D.scaleImage((Image)sourceImage, (int)size, (int)size, (boolean)true);
    }

    private void createICNS(List<Icon> iconSet) {
        Preconditions.checkArgument((boolean)this.location.getName().endsWith(".icns"), (Object)"Output file must be an ICNS icon");
        try {
            File tempDir = FileUtils.createTempDir();
            File iconSetDir = this.createMacIconSet(iconSet, tempDir);
            String inputPath = iconSetDir.getAbsolutePath();
            String outputPath = this.location.getAbsolutePath();
            new ProcessBuilder("iconutil", "-c", "icns", inputPath, "-o", outputPath).inheritIO().start().waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Unable to create icon", e);
        }
    }

    private File createMacIconSet(List<Icon> iconSet, File tempDir) throws IOException {
        File iconSetDir = new File(tempDir, "icon.iconset");
        if (iconSetDir.exists()) {
            throw new IOException("Icon set already exists: " + iconSetDir.getAbsolutePath());
        }
        iconSetDir.mkdir();
        this.saveIconSet(iconSet, iconSetDir);
        return iconSetDir;
    }

    private void saveIconSet(List<Icon> iconSet, File dir) throws IOException {
        for (Icon icon : iconSet) {
            File imageFile = new File(dir, icon.name);
            Utils2D.savePNG((BufferedImage)icon.image, (File)imageFile);
        }
    }

    private void createIOS(List<Icon> iconSet) throws IOException {
        this.location.mkdir();
        this.saveIconSet(iconSet, this.location);
        this.generateContentsJSON(iconSet, new File(this.location, "Contents.json"));
    }

    private void generateContentsJSON(List<Icon> iconSet, File outputFile) {
        try (PrintWriter writer = new PrintWriter(outputFile, Charsets.UTF_8);){
            writer.println("{");
            writer.println("  \"images\" : [");
            for (Icon icon : iconSet) {
                writer.println("    {");
                writer.println("      \"size\" : \"" + icon.getSize() + "\",");
                writer.println("      \"idiom\" : \"" + icon.getIdiom() + "\",");
                writer.println("      \"filename\" : \"" + icon.name + "\",");
                writer.println("      \"scale\" : \"" + icon.variant + "x\"");
                writer.println(iconSet.get(iconSet.size() - 1).equals(icon) ? "    }" : "    },");
            }
            writer.println("  ],");
            writer.println("  \"info\" : {");
            writer.println("    \"version\" : 1,");
            writer.println("    \"author\" : \"xcode\"");
            writer.println("  }");
            writer.println("}");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to generate " + outputFile.getAbsolutePath());
        }
    }

    private static class Icon {
        private String name;
        private int variant;
        private BufferedImage image;

        public Icon(String name, int variant, BufferedImage image) {
            this.name = name;
            this.variant = variant;
            this.image = image;
        }

        public String getSize() {
            int size = this.image.getWidth() / this.variant;
            return size + "x" + size;
        }

        public String getIdiom() {
            if (this.image.getWidth() == 1024) {
                return "ios-marketing";
            }
            if (this.image.getWidth() % 76 == 0) {
                return "ipad";
            }
            return "iphone";
        }
    }
}

