/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.multimedialib.tool.AppleIconTool;
import nl.colorize.multimedialib.tool.CommandLineTool;
import nl.colorize.util.LogHelper;
import nl.colorize.util.ResourceFile;
import org.kohsuke.args4j.Option;
import org.teavm.apachecommons.io.FileUtils;

public class CordovaWrapper
extends CommandLineTool {
    @Option(name="-webapp", required=true, usage="Directory containing the TeaVM version of the application")
    public File webAppDir;
    @Option(name="-out", required=true, usage="Output directory for the generated apps")
    public File outputDir;
    @Option(name="-platforms", usage="Comma-separated list of platforms, default is ios/android/osx")
    public String platforms = "ios,android,osx";
    @Option(name="-appid", required=true, usage="Application identifier, e.g. nl.colorize.test")
    public String appID;
    @Option(name="-appname", required=true, usage="Application display name")
    public String appName;
    @Option(name="-version", required=true, usage="Application version in the format x.y.z.")
    public String version;
    @Option(name="-icon", required=true, usage="Application icon, should be a 1024x1024 PNG image")
    public File iconFile;
    @Option(name="-buildjson", required=true, usage="Location of the Cordova build.json file")
    public File buildJSON;
    @Option(name="-dist", usage="Build distribution type, either 'release' (default) or 'debug'")
    public String dist = "release";
    private static final ResourceFile CONFIG_TEMPLATE = new ResourceFile("cordova/config.xml");
    private static final Splitter ARG_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    private static final Joiner COMMAND_JOINER = Joiner.on((String)" ");
    private static final Logger LOGGER = LogHelper.getLogger(CordovaWrapper.class);

    public static void main(String[] args) {
        CordovaWrapper tool = new CordovaWrapper();
        tool.start(args);
    }

    @Override
    public void run() {
        try {
            if (!this.outputDir.exists()) {
                LOGGER.info("Creating Cordova app in " + this.outputDir.getAbsolutePath());
                this.createCordovaApp();
                this.generateIcon();
            }
            LOGGER.info("Building Cordova app");
            this.updateConfig();
            this.buildCordovaApp();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Unable to build Cordova app", e);
        }
    }

    private void createCordovaApp() throws IOException {
        this.outputDir.mkdir();
        this.runCordova("cordova", "create", this.outputDir.getAbsolutePath(), this.appID, this.appName);
        Files.copy((File)this.iconFile, (File)new File(this.outputDir, "icon.png"));
        Files.copy((File)this.buildJSON, (File)new File(this.outputDir, "build.json"));
        List platformList = ARG_SPLITTER.splitToList((CharSequence)this.platforms);
        this.runCordova(Iterables.concat((Iterable)ImmutableList.of((Object)"cordova", (Object)"platform", (Object)"add"), (Iterable)platformList));
        File android = new File(this.outputDir.getAbsolutePath() + "/platforms/android/app/build.gradle");
        Files.append((CharSequence)"android.lintOptions.checkReleaseBuilds = false\n", (File)android, (Charset)Charsets.UTF_8);
    }

    private void generateIcon() {
        AppleIconTool iconTool = new AppleIconTool();
        iconTool.inputImageFile = this.iconFile;
        iconTool.location = this.getOutput("platforms/ios/" + this.appName + "/Images.xcassets/AppIcon.appiconset");
        iconTool.platform = "ios";
        iconTool.run();
    }

    private void updateConfig() throws IOException {
        String config = CONFIG_TEMPLATE.read(Charsets.UTF_8);
        config = config.replace("@@@ID", this.appID);
        config = config.replace("@@@NAME", this.appName);
        config = config.replace("@@@VERSION", this.version);
        File configFile = new File(this.outputDir, "config.xml");
        Files.write((CharSequence)config, (File)configFile, (Charset)Charsets.UTF_8);
    }

    private void buildCordovaApp() throws IOException {
        File appRoot = new File(this.outputDir, "www");
        FileUtils.deleteDirectory((File)appRoot);
        FileUtils.copyDirectory((File)this.webAppDir, (File)appRoot);
        ArrayList<String> command = new ArrayList<String>();
        command.add("cordova");
        command.add("build");
        command.addAll(ARG_SPLITTER.splitToList((CharSequence)this.platforms));
        if (this.dist.equals("release")) {
            command.add("--release");
            command.add("--device");
        }
        this.runCordova(command);
    }

    private void runCordova(String ... command) {
        LOGGER.info(COMMAND_JOINER.join((Object[])command));
        ProcessBuilder processBuilder = new ProcessBuilder(command).directory(this.outputDir).inheritIO();
        String java8Home = System.getenv("JAVA8_HOME");
        Preconditions.checkState((java8Home != null ? 1 : 0) != 0, (Object)"Cordova required environment variable JAVA8_HOME that refers to Java 8");
        Map<String, String> env = processBuilder.environment();
        env.put("JAVA_HOME", java8Home);
        try {
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new IOException("Process failed with exit code " + exitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Process failed");
        }
    }

    private void runCordova(Iterable<String> command) {
        this.runCordova((String[])ImmutableList.copyOf(command).toArray((Object[])new String[0]));
    }

    private File getOutput(String path) {
        return new File(this.outputDir.getAbsolutePath() + "/" + path);
    }
}

