/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import com.google.common.math.Stats;
import java.util.ArrayList;
import java.util.List;

public class Extrapolation {
    private List<Float> buffer;
    private int bufferSize;

    public Extrapolation(int bufferSize) {
        Preconditions.checkArgument((bufferSize >= 1 ? 1 : 0) != 0, (Object)("Invalid buffer size: " + bufferSize));
        this.buffer = new ArrayList<Float>();
        this.bufferSize = bufferSize;
    }

    public void add(float value) {
        this.buffer.add(Float.valueOf(value));
        if (this.buffer.size() > this.bufferSize) {
            this.buffer = this.buffer.subList(this.buffer.size() - this.bufferSize, this.buffer.size());
        }
    }

    public void reset() {
        this.buffer.clear();
    }

    public float extrapolate() {
        if (this.buffer.isEmpty()) {
            return 0.0f;
        }
        if (this.buffer.size() == 1) {
            return this.buffer.get(0).floatValue();
        }
        ArrayList<Float> deltas = new ArrayList<Float>();
        for (int i = 1; i < this.buffer.size(); ++i) {
            deltas.add(Float.valueOf(this.buffer.get(i).floatValue() - this.buffer.get(i - 1).floatValue()));
        }
        float averageDelta = (float)Stats.meanOf(deltas);
        return this.buffer.get(this.buffer.size() - 1).floatValue() + averageDelta;
    }
}

