/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.java2d.Java2DRenderer;
import nl.colorize.multimedialib.renderer.java2d.WindowOptions;
import nl.colorize.multimedialib.renderer.libgdx.GDXRenderer;
import nl.colorize.multimedialib.renderer.teavm.TeaRenderer;

public class RendererFactory {
    private int framerate = 60;
    private WindowOptions windowOptions = new WindowOptions("MultimediaLib");

    public void setFrameRate(int framerate) {
        Preconditions.checkArgument((boolean)ImmutableList.of((Object)20, (Object)25, (Object)30, (Object)60).contains((Object)framerate), (Object)("Frame rate not supported: " + framerate));
        this.framerate = framerate;
    }

    public int getFrameRate() {
        return this.framerate;
    }

    public void setWindowOptions(WindowOptions windowOptions) {
        this.windowOptions = windowOptions;
    }

    public WindowOptions getWindowOptions() {
        return this.windowOptions;
    }

    public Renderer create(Implementation type, Canvas canvas) {
        switch (type) {
            case JAVA2D: {
                return new Java2DRenderer(canvas, this.framerate, this.windowOptions);
            }
            case GDX: {
                return new GDXRenderer(canvas, this.framerate, this.windowOptions);
            }
            case TEAVM: {
                return new TeaRenderer(canvas);
            }
        }
        throw new AssertionError((Object)("Unknown renderer: " + (Object)((Object)type)));
    }

    public static enum Implementation {
        JAVA2D,
        GDX,
        TEAVM;

    }
}

