/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import java.util.UUID;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.teavm.Browser;

public class TeaImage
implements Image {
    private String id;
    private FilePointer origin;
    private Rect region;

    protected TeaImage(String id, FilePointer origin, Rect region) {
        this.id = id;
        this.origin = origin;
        this.region = region;
    }

    public String getId() {
        return this.id;
    }

    public FilePointer getOrigin() {
        return this.origin;
    }

    @Override
    public Rect getRegion() {
        return this.region;
    }

    @Override
    public int getWidth() {
        if (this.region != null) {
            return Math.round(this.region.getWidth());
        }
        return Math.round(Browser.getImageWidth(this.id));
    }

    @Override
    public int getHeight() {
        if (this.region != null) {
            return Math.round(this.region.getHeight());
        }
        return Math.round(Browser.getImageHeight(this.id));
    }

    @Override
    public TeaImage extractRegion(Rect region) {
        return new TeaImage(this.id, this.origin, region);
    }

    @Override
    public ColorRGB getColor(int x, int y) {
        float[] rgba = Browser.getImageData(this.id, x, y);
        int r = Math.round(rgba[0]);
        int g = Math.round(rgba[1]);
        int b = Math.round(rgba[2]);
        if (r < 0) {
            return null;
        }
        return new ColorRGB(r, g, b);
    }

    @Override
    public int getAlpha(int x, int y) {
        float[] rgba = Browser.getImageData(this.id, x, y);
        return Math.round(rgba[3] / 2.55f);
    }

    @Override
    public Image tint(ColorRGB color) {
        String newId = this.id + "-tinted-" + UUID.randomUUID();
        Browser.tintImage(this.id, newId, color.toHex());
        return new TeaImage(newId, this.origin, this.region);
    }

    public String toString() {
        return this.origin.getPath();
    }
}

