/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.RotatingBuffer;
import nl.colorize.multimedialib.renderer.ApplicationData;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GraphicsContext2D;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.NetworkAccess;
import nl.colorize.multimedialib.renderer.RenderCallback;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.Stage;
import nl.colorize.multimedialib.scene.MediaManager;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SubScene;
import nl.colorize.multimedialib.scene.effect.Effect;
import nl.colorize.util.PlatformFamily;
import nl.colorize.util.Stopwatch;
import nl.colorize.util.animation.Interpolation;
import nl.colorize.util.animation.Timeline;

public final class Application
implements RenderCallback {
    private Renderer renderer;
    private MediaManager media;
    private Scene activeScene = null;
    private List<SubScene> activeSubScenes = new ArrayList<SubScene>();
    private Scene requestedScene = null;
    private List<SubScene> requestedSubScenes = new ArrayList<SubScene>();
    private List<SubScene> completedSubScenes = new ArrayList<SubScene>();
    private Stopwatch fpsTimer = new Stopwatch();
    private RotatingBuffer fpsBuffer = new RotatingBuffer(100, 1000.0f);
    private RotatingBuffer frameTimeBuffer = new RotatingBuffer(100);
    private RotatingBuffer upsBuffer = new RotatingBuffer(100, 1000.0f);
    private boolean orientationLock;
    private Effect orientationLockAnim;
    private static final int FPS_MEASUREMENT_BUFFER_SIZE = 100;
    private static final FilePointer ORIENTATION_LOCK_IMAGE = new FilePointer("orientation-lock.png");

    private Application() {
    }

    private void init() {
        this.media = new MediaManager(this.renderer.getMediaLoader());
        this.orientationLock = false;
        this.orientationLockAnim = this.initOrientationLockAnim();
    }

    private Effect initOrientationLockAnim() {
        Image orientationLockImage = this.getMediaLoader().loadImage(ORIENTATION_LOCK_IMAGE);
        Timeline timeline = new Timeline(Interpolation.EASE, true);
        timeline.addKeyFrame(0.0f, 100.0f);
        timeline.addKeyFrame(1.0f, 110.0f);
        timeline.addKeyFrame(2.0f, 100.0f);
        Effect effect = Effect.forImage(orientationLockImage, timeline);
        effect.modify(value -> effect.getTransform().setScale(Math.round(value.floatValue())));
        return effect;
    }

    @Override
    public void update(Renderer renderer, float deltaTime) {
        if (this.renderer == null) {
            this.renderer = renderer;
            this.init();
        }
        Stopwatch frameTimer = new Stopwatch();
        frameTimer.tick();
        this.updateFrame(deltaTime);
        long actualFrameTime = frameTimer.tick();
        this.frameTimeBuffer.add(actualFrameTime);
    }

    private void updateFrame(float deltaTime) {
        this.upsBuffer.add(deltaTime);
        if (this.requestedScene != null) {
            this.activateRequestedScene();
        }
        this.activeSubScenes.addAll(this.requestedSubScenes);
        this.requestedSubScenes.clear();
        this.activeSubScenes.removeAll(this.completedSubScenes);
        this.completedSubScenes.clear();
        if (this.activeScene != null && this.isScreenOrientationSupported()) {
            this.updateActiveScene(deltaTime);
        } else {
            this.orientationLockAnim.update(deltaTime);
        }
    }

    private void updateActiveScene(float deltaTime) {
        this.activeScene.update(this, deltaTime);
        for (SubScene subScene : this.activeSubScenes) {
            subScene.update(deltaTime);
            if (!subScene.isCompleted()) continue;
            this.completedSubScenes.add(subScene);
        }
    }

    private void activateRequestedScene() {
        if (this.activeScene != null) {
            this.activeScene.end(this);
            this.activeSubScenes.clear();
            this.completedSubScenes.clear();
        }
        if (this.renderer.getSupportedGraphicsMode() == GraphicsMode.ALL) {
            Stage stage = this.renderer.getStage();
            stage.clear();
        }
        this.activeScene = this.requestedScene;
        this.requestedScene = null;
        this.activeScene.start(this);
    }

    @Override
    public void render(Renderer renderer, GraphicsContext2D graphics) {
        long fpsValue = this.fpsTimer.tick();
        this.fpsBuffer.add(fpsValue);
        if (!this.isScreenOrientationSupported()) {
            this.drawOrientationLock(graphics);
            return;
        }
        if (this.activeScene != null) {
            this.renderActiveScene(graphics);
        }
    }

    private void renderActiveScene(GraphicsContext2D graphics) {
        for (SubScene subScene : this.activeSubScenes) {
            if (!subScene.hasBackgroundGraphics()) continue;
            subScene.render(graphics);
        }
        this.activeScene.render(this, graphics);
        for (SubScene subScene : this.activeSubScenes) {
            if (subScene.hasBackgroundGraphics()) continue;
            subScene.render(graphics);
        }
    }

    public void changeScene(Scene requestedScene) {
        Preconditions.checkState((this.requestedScene == null ? 1 : 0) != 0, (Object)("Another scene has already been requested: " + requestedScene));
        this.requestedScene = requestedScene;
    }

    public Scene getActiveScene() {
        return this.activeScene;
    }

    public void attach(SubScene subScene) {
        this.requestedSubScenes.add(subScene);
    }

    public void detach(SubScene subScene) {
        this.requestedSubScenes.remove(subScene);
        this.activeSubScenes.remove(subScene);
    }

    public List<SubScene> getActiveSubScenes() {
        return ImmutableList.copyOf(this.activeSubScenes);
    }

    public void lockScreenOrientation() {
        this.orientationLock = true;
    }

    private boolean isScreenOrientationSupported() {
        if (!this.orientationLock) {
            return true;
        }
        Canvas canvas = this.renderer.getCanvas();
        return canvas.getWidth() > 0 && canvas.getWidth() > canvas.getHeight();
    }

    private void drawOrientationLock(GraphicsContext2D graphics) {
        Canvas canvas = this.getCanvas();
        this.orientationLockAnim.setPosition((float)canvas.getWidth() / 2.0f, (float)canvas.getHeight() / 2.0f);
        this.orientationLockAnim.render(graphics);
    }

    @Deprecated
    public Renderer getRenderer() {
        return this.renderer;
    }

    public Canvas getCanvas() {
        return this.renderer.getCanvas();
    }

    public Stage getStage() {
        return this.renderer.getStage();
    }

    public InputDevice getInputDevice() {
        return this.renderer.getInputDevice();
    }

    public MediaLoader getMediaLoader() {
        return this.renderer.getMediaLoader();
    }

    public MediaManager getMedia() {
        return this.media;
    }

    public ApplicationData getApplicationData(String appName) {
        return this.renderer.getApplicationData(appName);
    }

    public NetworkAccess getNetwork() {
        return this.renderer.getNetwork();
    }

    public PlatformFamily getPlatform() {
        return this.renderer.getPlatform();
    }

    public String getDistributionChannel() {
        PlatformFamily platform = this.getPlatform();
        switch (platform) {
            case IOS: {
                return "App Store";
            }
            case ANDROID: {
                return "Google Play";
            }
            case MAC: {
                return "Mac App Store";
            }
            case TEAVM: {
                return "Web";
            }
        }
        return "Download";
    }

    public String getScreenSize() {
        Canvas canvas = this.renderer.getCanvas();
        int width = Math.round((float)canvas.getWidth() * canvas.getZoomLevel());
        int height = Math.round((float)canvas.getHeight() * canvas.getZoomLevel());
        return width + "x" + height;
    }

    public float getAverageFramerate() {
        return 1000.0f / this.fpsBuffer.getAverageValue();
    }

    public float getAverageFrameTime() {
        return this.frameTimeBuffer.getAverageValue();
    }

    public float getAverageUpdateRate() {
        return 1.0f / this.upsBuffer.getAverageValue();
    }

    @Deprecated
    public static Application start(Renderer renderer) {
        Application app = new Application();
        renderer.attach(app);
        renderer.start();
        return app;
    }

    public static void start(Renderer renderer, Scene initialScene) {
        Application app = new Application();
        app.changeScene(initialScene);
        renderer.attach(app);
        renderer.start();
    }
}

