/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene.ui;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.renderer.Canvas;

public class Location {
    private Canvas canvas;
    private BorderAlign xAlign;
    private float xOffset;
    private BorderAlign yAlign;
    private float yOffset;

    private Location(Canvas canvas, BorderAlign xAlign, float xOffset, BorderAlign yAlign, float yOffset) {
        Preconditions.checkArgument((xOffset >= 0.0f && yOffset >= 0.0f ? 1 : 0) != 0, (Object)("Negative coordinates are not supported: " + xOffset + ", " + yOffset));
        this.canvas = canvas;
        this.xAlign = xAlign;
        this.xOffset = xOffset;
        this.yAlign = yAlign;
        this.yOffset = yOffset;
    }

    public float getX() {
        switch (this.xAlign) {
            case LEFT: {
                return this.xOffset;
            }
            case RIGHT: {
                return (float)this.canvas.getWidth() - this.xOffset;
            }
            case CENTER: {
                return (float)this.canvas.getWidth() / 2.0f;
            }
        }
        throw new IllegalArgumentException("Invalid alignment: " + (Object)((Object)this.xAlign));
    }

    public float getY() {
        switch (this.yAlign) {
            case TOP: {
                return this.yOffset;
            }
            case BOTTOM: {
                return (float)this.canvas.getHeight() - this.yOffset;
            }
            case CENTER: {
                return (float)this.canvas.getHeight() / 2.0f;
            }
        }
        throw new IllegalArgumentException("Invalid alignment: " + (Object)((Object)this.yAlign));
    }

    public Point2D toPoint() {
        return new Point2D(this.getX(), this.getY());
    }

    public Location relativeTo(float deltaX, float deltaY) {
        float newX = this.xOffset + (this.xAlign == BorderAlign.RIGHT ? -deltaX : deltaX);
        float newY = this.yOffset + (this.yAlign == BorderAlign.BOTTOM ? -deltaY : deltaY);
        return new Location(this.canvas, this.xAlign, newX, this.yAlign, newY);
    }

    public String toString() {
        return (Object)((Object)this.xAlign) + " " + Math.round(this.xOffset) + ", " + (Object)((Object)this.yAlign) + " " + Math.round(this.yOffset);
    }

    public static Location fixed(float x, float y) {
        return new Location(null, BorderAlign.LEFT, x, BorderAlign.TOP, y);
    }

    public static Location left(Canvas canvas, float x, float y) {
        return new Location(canvas, BorderAlign.LEFT, x, BorderAlign.TOP, y);
    }

    public static Location right(Canvas canvas, float x, float y) {
        return new Location(canvas, BorderAlign.RIGHT, x, BorderAlign.TOP, y);
    }

    public static Location center(Canvas canvas, float y) {
        return new Location(canvas, BorderAlign.CENTER, 0.0f, BorderAlign.TOP, y);
    }

    public static Location top(Canvas canvas, float x, float y) {
        return new Location(canvas, BorderAlign.LEFT, x, BorderAlign.TOP, y);
    }

    public static Location bottom(Canvas canvas, float x, float y) {
        return new Location(canvas, BorderAlign.LEFT, x, BorderAlign.BOTTOM, y);
    }

    public static Location bottomCenter(Canvas canvas, float y) {
        return new Location(canvas, BorderAlign.CENTER, 0.0f, BorderAlign.BOTTOM, y);
    }

    public static Location bottomRight(Canvas canvas, float x, float y) {
        return new Location(canvas, BorderAlign.RIGHT, x, BorderAlign.BOTTOM, y);
    }

    private static enum BorderAlign {
        LEFT,
        RIGHT,
        CENTER,
        TOP,
        BOTTOM;

    }
}

