/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import nl.colorize.util.MessageBuffer;

public final class NetworkConnection {
    private AtomicBoolean connected = new AtomicBoolean(false);
    private String id = null;
    private MessageBuffer<String> sendBuffer = new MessageBuffer();
    private MessageBuffer<String> receiveBuffer = new MessageBuffer();
    private Consumer<String> sender;

    public NetworkConnection(Consumer<String> sender) {
        this.sender = sender;
    }

    public void connect() {
        this.connected.set(true);
        for (String message : this.sendBuffer.flush()) {
            this.sender.accept(message);
        }
    }

    public void disconnect() {
        this.connected.set(false);
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    public synchronized void receiveID(String id) {
        this.id = id;
    }

    public synchronized String getID() {
        return this.id;
    }

    public void send(String message) {
        if (this.isConnected()) {
            this.sender.accept(message);
        } else {
            this.sendBuffer.add((Object)message);
        }
    }

    public void queueReceivedMessage(String message) {
        this.receiveBuffer.add((Object)message);
    }

    public List<String> receive() {
        return this.receiveBuffer.flush();
    }
}

