/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import nl.colorize.multimedialib.graphics.Align;
import nl.colorize.multimedialib.graphics.AlphaTransform;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsContext2D;
import nl.colorize.multimedialib.renderer.libgdx.GDXImage;
import nl.colorize.multimedialib.renderer.libgdx.GDXMediaLoader;

public class GDXGraphics2D
implements GraphicsContext2D {
    private Canvas canvas;
    private GDXMediaLoader mediaLoader;
    private SpriteBatch spriteBatch;
    private ShapeRenderer shapeBatch;
    private Texture nullTexture;
    private Map<TextureRegion, TextureRegion> maskCache;
    private static final Transform DEFAULT_TRANSFORM = new Transform();
    private static final int CIRCLE_SEGMENTS = 32;

    protected GDXGraphics2D(Canvas canvas, GDXMediaLoader mediaLoader) {
        this.canvas = canvas;
        this.mediaLoader = mediaLoader;
        this.spriteBatch = new SpriteBatch();
        this.shapeBatch = new ShapeRenderer();
        this.nullTexture = this.generateNullTexture();
        this.maskCache = new HashMap<TextureRegion, TextureRegion>();
    }

    private Texture generateNullTexture() {
        Pixmap pixmap = new Pixmap(16, 16, Pixmap.Format.RGBA8888);
        pixmap.setColor(0.0f, 1.0f, 0.0f, 1.0f);
        pixmap.fill();
        Texture texture = new Texture(pixmap);
        pixmap.dispose();
        return texture;
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas;
    }

    @Override
    public void drawBackground(ColorRGB backgroundColor) {
        Canvas canvas = this.getCanvas();
        Rect background = new Rect(0.0f, 0.0f, canvas.getWidth(), canvas.getHeight());
        this.drawRect(background, backgroundColor, null);
    }

    @Override
    public void drawLine(Point2D from, Point2D to, ColorRGB color, float thickness) {
        float x0 = this.toScreenX(from.getX());
        float y0 = this.toScreenY(from.getY());
        float x1 = this.toScreenX(to.getX());
        float y1 = this.toScreenY(to.getY());
        this.switchMode(false, true);
        this.shapeBatch.setColor(this.convertColor(color));
        this.shapeBatch.line(x0, y0, x1, y1);
    }

    @Override
    public void drawRect(Rect rect, ColorRGB color, AlphaTransform alpha) {
        float x = this.toScreenX(rect.getX());
        float y = this.toScreenY(rect.getEndY());
        float width = rect.getWidth() * this.canvas.getZoomLevel();
        float height = rect.getHeight() * this.canvas.getZoomLevel();
        this.switchMode(false, true);
        this.shapeBatch.setColor(this.convertColor(color, alpha));
        this.shapeBatch.rect(x, y, width, height);
    }

    @Override
    public void drawCircle(Circle circle, ColorRGB color, AlphaTransform alpha) {
        float x = this.toScreenX(circle.getCenterX());
        float y = this.toScreenY(circle.getCenterY());
        float radius = circle.getRadius() * this.canvas.getZoomLevel();
        this.switchMode(false, true);
        this.shapeBatch.setColor(this.convertColor(color, alpha));
        this.shapeBatch.circle(x, y, radius, 32);
    }

    @Override
    public void drawPolygon(Polygon polygon, ColorRGB color, AlphaTransform alpha) {
        if (polygon.getNumPoints() == 3) {
            this.drawTriangle(polygon.getVertices(), color, alpha);
        } else {
            for (Polygon triangle : polygon.subdivide()) {
                this.drawTriangle(triangle.getVertices(), color, alpha);
            }
        }
    }

    private void drawTriangle(float[] vertices, ColorRGB color, AlphaTransform alpha) {
        this.switchMode(false, true);
        this.shapeBatch.setColor(this.convertColor(color, alpha));
        this.shapeBatch.triangle(this.toScreenX(vertices[0]), this.toScreenY(vertices[1]), this.toScreenX(vertices[2]), this.toScreenY(vertices[3]), this.toScreenX(vertices[4]), this.toScreenY(vertices[5]));
    }

    @Override
    public void drawImage(Image image, float x, float y, Transform transform) {
        TextureRegion textureRegion = ((GDXImage)image).getTextureRegion();
        if (transform == null) {
            transform = DEFAULT_TRANSFORM;
        }
        this.drawSprite(textureRegion, x, y, transform);
    }

    private void drawSprite(TextureRegion textureRegion, float x, float y, Transform transform) {
        float screenX = this.toScreenX(x);
        float screenY = this.toScreenY(y);
        float screenWidth = (float)textureRegion.getRegionWidth() * this.canvas.getZoomLevel();
        float screenHeight = (float)textureRegion.getRegionHeight() * this.canvas.getZoomLevel();
        float scaleX = transform.getScaleX() / 100.0f * (transform.isFlipHorizontal() ? -1.0f : 1.0f);
        float scaleY = transform.getScaleY() / 100.0f * (transform.isFlipVertical() ? -1.0f : 1.0f);
        if (transform.getMask() != null) {
            textureRegion = this.getMask(textureRegion, transform.getMask());
        }
        this.switchMode(true, false);
        this.spriteBatch.setColor(1.0f, 1.0f, 1.0f, transform.getAlpha() / 100.0f);
        this.spriteBatch.draw(textureRegion, screenX - screenWidth / 2.0f, screenY - screenHeight / 2.0f, screenWidth / 2.0f, screenHeight / 2.0f, screenWidth, screenHeight, scaleX, scaleY, transform.getRotation());
    }

    private TextureRegion getMask(TextureRegion textureRegion, ColorRGB color) {
        TextureRegion mask = this.maskCache.get(textureRegion);
        if (mask == null) {
            mask = this.createMask(textureRegion, color);
            this.maskCache.put(textureRegion, mask);
        }
        return mask;
    }

    private TextureRegion createMask(TextureRegion original, ColorRGB color) {
        TextureData textureData = original.getTexture().getTextureData();
        textureData.prepare();
        Pixmap pixels = textureData.consumePixmap();
        Pixmap mask = new Pixmap(original.getRegionWidth(), original.getRegionHeight(), Pixmap.Format.RGBA8888);
        for (int x = 0; x < original.getRegionWidth(); ++x) {
            for (int y = 0; y < original.getRegionHeight(); ++y) {
                int rgba = pixels.getPixel(original.getRegionX() + x, original.getRegionY() + y);
                int maskRGBA = Color.rgba8888((Color)this.convertColor(color, new Color((int)rgba).a * 100.0f));
                mask.drawPixel(x, y, maskRGBA);
            }
        }
        Texture texture = new Texture(mask);
        pixels.dispose();
        mask.dispose();
        return new TextureRegion(texture);
    }

    @Override
    public void drawText(String text, TTFont font, float x, float y, Align align, AlphaTransform alpha) {
        int actualSize = Math.round((float)font.getSize() * this.canvas.getZoomLevel());
        BitmapFont bitmapFont = this.mediaLoader.getBitmapFont(font, actualSize);
        float screenX = this.toScreenX(x);
        float screenY = this.toScreenY(y - 0.5f * (float)actualSize);
        this.switchMode(true, false);
        bitmapFont.draw((Batch)this.spriteBatch, (CharSequence)text, screenX, screenY, 0.0f, this.getTextAlign(align), false);
    }

    private int getTextAlign(Align align) {
        switch (align) {
            case LEFT: {
                return 8;
            }
            case CENTER: {
                return 1;
            }
            case RIGHT: {
                return 16;
            }
        }
        throw new AssertionError();
    }

    private float toScreenX(float x) {
        return this.canvas.toScreenX(x);
    }

    public float toScreenY(float y) {
        return (float)Gdx.graphics.getHeight() - this.canvas.toScreenY(y);
    }

    private Color convertColor(ColorRGB color, float alpha) {
        return new Color((float)color.getR() / 255.0f, (float)color.getG() / 255.0f, (float)color.getB() / 255.0f, alpha / 100.0f);
    }

    private Color convertColor(ColorRGB color, AlphaTransform alpha) {
        float alphaValue = alpha != null ? alpha.getAlpha() : 100.0f;
        return this.convertColor(color, alphaValue);
    }

    private Color convertColor(ColorRGB color) {
        return this.convertColor(color, 100.0f);
    }

    protected void switchMode(boolean sprites, boolean shapes) {
        Preconditions.checkArgument((!sprites || !shapes ? 1 : 0) != 0, (Object)"Invalid drawing mode");
        if (sprites) {
            this.endShapeBatch();
            this.beginSpriteBatch();
        } else if (shapes) {
            this.endSpriteBatch();
            this.beginShapeBatch();
        } else {
            this.endSpriteBatch();
            this.endShapeBatch();
        }
    }

    private void beginSpriteBatch() {
        if (!this.spriteBatch.isDrawing()) {
            this.spriteBatch.begin();
        }
    }

    private void endSpriteBatch() {
        if (this.spriteBatch.isDrawing()) {
            this.spriteBatch.end();
        }
    }

    private void beginShapeBatch() {
        if (!this.shapeBatch.isDrawing()) {
            Gdx.gl.glEnable(3042);
            this.shapeBatch.begin(ShapeRenderer.ShapeType.Filled);
        }
    }

    private void endShapeBatch() {
        if (this.shapeBatch.isDrawing()) {
            this.shapeBatch.end();
        }
    }

    protected void dispose() {
        this.endSpriteBatch();
        this.endShapeBatch();
        this.spriteBatch.dispose();
        this.shapeBatch.dispose();
    }
}

