/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.java2d.WindowOptions;
import nl.colorize.multimedialib.renderer.libgdx.GDXBackend;

public class LWJGLBackend
implements GDXBackend {
    private int framerate;
    private WindowOptions windowOptions;

    public LWJGLBackend(int framerate, WindowOptions windowOptions) {
        Preconditions.checkArgument((framerate == 30 || framerate == 60 || framerate == 120 ? 1 : 0) != 0, (Object)("Framerate not supported: " + framerate));
        this.framerate = framerate;
        this.windowOptions = windowOptions;
    }

    @Override
    public void start(ApplicationListener app, Canvas canvas) {
        Lwjgl3ApplicationConfiguration config = new Lwjgl3ApplicationConfiguration();
        config.setWindowedMode(canvas.getWidth(), canvas.getHeight());
        config.setDecorated(true);
        config.setIdleFPS(this.framerate);
        config.setHdpiMode(HdpiMode.Pixels);
        config.setTitle(this.windowOptions.getTitle());
        if (this.windowOptions.hasIcon()) {
            config.setWindowIcon(Files.FileType.Internal, new String[]{this.windowOptions.getIconFile().getPath()});
        }
        new Lwjgl3Application(app, config);
    }

    @Override
    public int getFramerate() {
        return this.framerate;
    }
}

