/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import nl.colorize.multimedialib.renderer.Drawable;
import nl.colorize.multimedialib.renderer.GraphicsContext2D;
import nl.colorize.multimedialib.renderer.Updatable;
import nl.colorize.multimedialib.scene.effect.Timer;

public interface SubScene
extends Updatable,
Drawable {
    public boolean isCompleted();

    default public boolean hasBackgroundGraphics() {
        return false;
    }

    public static SubScene from(Updatable logic, Drawable graphics) {
        return SubScene.from(logic, graphics, Float.MAX_VALUE);
    }

    public static SubScene from(final Updatable logic, final Drawable graphics, float duration) {
        final Timer timer = new Timer(duration);
        return new SubScene(){

            @Override
            public void update(float deltaTime) {
                logic.update(deltaTime);
                timer.update(deltaTime);
            }

            @Override
            public void render(GraphicsContext2D gc) {
                graphics.render(gc);
            }

            @Override
            public boolean isCompleted() {
                return timer.isCompleted();
            }
        };
    }

    public static SubScene fromLogic(Updatable logic) {
        return SubScene.from(logic, g -> {});
    }

    public static SubScene fromGraphics(Drawable graphics) {
        return SubScene.from(deltaTime -> {}, graphics);
    }
}

