/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene.ui;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.graphics.Align;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.GraphicsContext2D;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.scene.ui.Widget;
import nl.colorize.multimedialib.scene.ui.WidgetStyle;

public class Button
extends Widget {
    private String label;
    private int width;
    private int height;
    private InputDevice input;
    private Runnable onClick;

    public Button(WidgetStyle style, String label) {
        super(style);
        this.label = label;
        if (style.getBackground() != null) {
            this.width = style.getBackground().getWidth();
            this.height = style.getBackground().getHeight();
        }
    }

    public Button(WidgetStyle style) {
        this(style, "");
    }

    public void setClickHandler(InputDevice input, Runnable onClick) {
        this.input = input;
        this.onClick = onClick;
    }

    @Override
    public void update(float deltaTime) {
        Preconditions.checkState((this.onClick != null ? 1 : 0) != 0, (Object)"Click handler has not been set");
        if (this.input.isPointerReleased(this.getBounds())) {
            this.onClick.run();
        }
    }

    private Rect getBounds() {
        return Rect.around(this.getX(), this.getY(), this.width, this.height);
    }

    @Override
    public void render(GraphicsContext2D graphics, WidgetStyle style) {
        if (style.getBorderColor() != null && style.getBorderSize() > 0) {
            this.drawBorder(graphics, style);
        }
        if (style.getBackground() != null) {
            graphics.drawImage(style.getBackground(), this.getX(), this.getY(), null);
        } else if (style.getBackgroundColor() != null) {
            graphics.drawRect(this.getBounds(), style.getBackgroundColor());
        }
        if (this.label != null && style.getFont() != null) {
            graphics.drawText(this.label, style.getFont(), this.getX(), this.getY() + (float)this.height * 0.35f, Align.CENTER);
        }
    }

    private void drawBorder(GraphicsContext2D graphics, WidgetStyle style) {
        Rect bounds = this.getBounds();
        int borderSize = style.getBorderSize();
        Rect border = new Rect(bounds.getX() - (float)borderSize, bounds.getY() - (float)borderSize, bounds.getWidth() + (float)(2 * borderSize), bounds.getHeight() + (float)(2 * borderSize));
        graphics.drawRect(border, style.getBorderColor());
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }
}

