/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.math.MathUtils;
import nl.colorize.multimedialib.tool.CommandLineTool;
import nl.colorize.util.LogHelper;
import nl.colorize.util.swing.Utils2D;
import org.kohsuke.args4j.Option;

public class ImageManipulationTool
extends CommandLineTool {
    @Option(name="-input", required=true, usage="Input directory containing the source images")
    public File inputDir;
    @Option(name="-output", required=true, usage="Output directory for generated results")
    public File outputDir;
    @Option(name="-alpha", usage="Introduce alpha channel (color in the format #000000)")
    public String alphaChannel = null;
    @Option(name="-fade", usage="Fade image edge alpha using the specified edge size")
    public int fade = 0;
    private static final Color REAL_ALPHA = new Color(0, 0, 0, 0);
    private static final Logger LOGGER = LogHelper.getLogger(ImageManipulationTool.class);

    public static void main(String[] args) {
        ImageManipulationTool tool = new ImageManipulationTool();
        tool.start(args);
    }

    @Override
    public void run() {
        this.outputDir.mkdir();
        try {
            List imageFiles = Files.walk(this.inputDir.toPath(), new FileVisitOption[0]).map(path -> path.toFile()).filter(file -> this.isImageFile((File)file)).collect(Collectors.toList());
            for (File imageFile : imageFiles) {
                LOGGER.info("Converting image " + imageFile.getName());
                BufferedImage result = this.processImage(imageFile);
                File outputFile = new File(this.outputDir, imageFile.getName());
                Utils2D.savePNG((BufferedImage)result, (File)outputFile);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error while converting images", e);
        }
    }

    private boolean isImageFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        return file.getName().endsWith(".png") || file.getName().endsWith(".jpg");
    }

    private BufferedImage processImage(File file) throws IOException {
        BufferedImage image = Utils2D.loadImage((File)file);
        if (this.alphaChannel != null) {
            image = this.introduceAlphaChannel(image);
        }
        if (this.fade > 0) {
            image = this.fadeEdges(image);
        }
        return image;
    }

    private BufferedImage introduceAlphaChannel(BufferedImage original) {
        BufferedImage result = new BufferedImage(original.getWidth(), original.getHeight(), 2);
        Color alphaChannelColor = Utils2D.parseHexColor((String)this.alphaChannel);
        for (int x = 0; x < original.getWidth(); ++x) {
            for (int y = 0; y < original.getHeight(); ++y) {
                int rgb = original.getRGB(x, y);
                if (rgb == alphaChannelColor.getRGB()) {
                    rgb = REAL_ALPHA.getRGB();
                }
                result.setRGB(x, y, rgb);
            }
        }
        return result;
    }

    private BufferedImage fadeEdges(BufferedImage image) {
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                Color oldColor = new Color(image.getRGB(x, y));
                int edgeDistance = this.getEdgeDistance(image, x, y);
                int alpha = MathUtils.clamp(Math.round((float)edgeDistance * (255.0f / (float)this.fade)), 0, 255);
                Color newColor = new Color(oldColor.getRed(), oldColor.getGreen(), oldColor.getBlue(), alpha);
                result.setRGB(x, y, newColor.getRGB());
            }
        }
        return result;
    }

    private int getEdgeDistance(BufferedImage image, int x, int y) {
        int right = image.getWidth() - 1 - x;
        int bottom = image.getHeight() - 1 - y;
        return Math.min(Math.min(Math.min(x, y), right), bottom);
    }
}

