/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.google.common.base.Preconditions;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.multimedialib.tool.CommandLineTool;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.swing.Utils2D;
import org.kohsuke.args4j.Option;

public class ImageTileTool
extends CommandLineTool {
    @Option(name="-input", required=true, usage="Input image file")
    public File inputFile;
    @Option(name="-horizontal", usage="Times to tile the image horizontally")
    public int horizontal;
    @Option(name="-vertical", usage="Times to tile the image vertically")
    public int vertical;
    @Option(name="-horizontalsplit", usage="Splits the image using the specified offset")
    public int horizontalSplit = 0;
    @Option(name="-verticalsplit", usage="Splits the image using the specified offset")
    public int verticalSplit = 0;
    private static final Logger LOGGER = LogHelper.getLogger(ImageTileTool.class);

    public static void main(String[] args) {
        ImageTileTool tool = new ImageTileTool();
        tool.start(args);
    }

    @Override
    public void run() {
        try {
            BufferedImage image = Utils2D.loadImage((File)this.inputFile);
            List<BufferedImage> processed = this.processImage(image);
            File outputDir = new File(Platform.getUserDesktopDir(), "sprites");
            outputDir.mkdir();
            for (int i = 0; i < processed.size(); ++i) {
                File outputFile = new File(outputDir, this.inputFile.getName().replaceAll("-\\d*[.]png", "") + "-" + (i + 1) + ".png");
                Preconditions.checkState((!outputFile.exists() ? 1 : 0) != 0, (Object)("The file " + outputFile.getAbsolutePath() + " already exists"));
                LOGGER.info("Generating " + outputFile.getAbsolutePath());
                Utils2D.savePNG((BufferedImage)processed.get(i), (File)outputFile);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Cannot tile image", e);
        }
    }

    private List<BufferedImage> processImage(BufferedImage image) {
        ArrayList<BufferedImage> processed = new ArrayList<BufferedImage>();
        if (this.horizontal > 0 || this.vertical > 0) {
            processed.add(this.tileImage(image));
        } else if (this.horizontalSplit > 0 || this.verticalSplit > 0) {
            processed.addAll(this.splitImage(image));
        }
        return processed;
    }

    private BufferedImage tileImage(BufferedImage image) {
        BufferedImage result = new BufferedImage(image.getWidth() * this.horizontal, image.getHeight() * this.vertical, 2);
        Graphics2D g2 = Utils2D.createGraphics((BufferedImage)result, (boolean)false, (boolean)false);
        for (int i = 0; i < this.horizontal; ++i) {
            for (int j = 0; j < this.vertical; ++j) {
                g2.drawImage((Image)image, i * image.getWidth(), j * image.getHeight(), null);
            }
        }
        g2.dispose();
        return result;
    }

    private List<BufferedImage> splitImage(BufferedImage image) {
        ArrayList<BufferedImage> processed = new ArrayList<BufferedImage>();
        if (this.horizontalSplit > 0) {
            for (int x = 0; x < image.getWidth(); x += this.horizontalSplit) {
                processed.add(this.splitImage(image, x, 0));
            }
        }
        if (this.verticalSplit > 0) {
            for (int y = 0; y < image.getHeight(); y += this.verticalSplit) {
                processed.add(this.splitImage(image, 0, y));
            }
        }
        return processed;
    }

    private BufferedImage splitImage(BufferedImage image, int xOffset, int yOffset) {
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2 = Utils2D.createGraphics((BufferedImage)result, (boolean)false, (boolean)false);
        if (xOffset > 0) {
            g2.drawImage((Image)image, -image.getWidth() + xOffset, 0, null);
            g2.drawImage((Image)image, xOffset, 0, null);
        } else if (yOffset > 0) {
            g2.drawImage((Image)image, 0, -image.getHeight() + yOffset, null);
            g2.drawImage((Image)image, 0, yOffset, null);
        } else {
            g2.drawImage((Image)image, 0, 0, null);
        }
        g2.dispose();
        return result;
    }
}

