/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.graphics.AnimationInfo;
import nl.colorize.multimedialib.graphics.Image;

public class Animation
implements AnimationInfo {
    private List<FrameInfo> frames;
    private boolean loop;

    private Animation(List<FrameInfo> frames, boolean loop) {
        this.frames = ImmutableList.copyOf(frames);
        this.loop = loop;
    }

    public Animation(boolean loop) {
        this.frames = new ArrayList<FrameInfo>();
        this.loop = loop;
    }

    public Animation(List<Image> frames, float frameTime, boolean loop) {
        this(loop);
        for (Image frame : frames) {
            this.addFrame(frame, frameTime);
        }
    }

    public Animation(Image frame) {
        this(false);
        this.addFrame(frame, 0.0f);
    }

    public void addFrame(Image frame, float frameTime) {
        Preconditions.checkArgument((frameTime >= 0.0f ? 1 : 0) != 0, (Object)("Invalid frame time: " + frameTime));
        this.frames.add(new FrameInfo(frame, frameTime));
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    public List<Image> getFrameImages() {
        return this.frames.stream().map(frame -> frame.image).collect(Collectors.toList());
    }

    public Image getFrameAtIndex(int index) {
        return this.frames.get((int)index).image;
    }

    public Image getFrameAtTime(float time) {
        Preconditions.checkState((!this.frames.isEmpty() ? 1 : 0) != 0, (Object)"Animation does not contain any frames");
        if (this.frames.size() == 1) {
            return this.frames.get((int)0).image;
        }
        if (this.loop) {
            time %= this.getDuration();
        }
        for (FrameInfo frame : this.frames) {
            if (!((time -= frame.frameTime) < 0.0f)) continue;
            return frame.image;
        }
        return this.frames.get((int)(this.frames.size() - 1)).image;
    }

    @Override
    public float getDuration() {
        if (this.frames.size() <= 1) {
            return 0.0f;
        }
        float duration = 0.0f;
        for (FrameInfo frame : this.frames) {
            duration += frame.frameTime;
        }
        return duration;
    }

    public void setFrameTime(int index, float frameTime) {
        Preconditions.checkArgument((frameTime >= 0.0f ? 1 : 0) != 0, (Object)("Invalid frame time: " + frameTime));
        this.frames.get((int)index).frameTime = frameTime;
    }

    public void setFrameTimes(List<Float> frameTimes) {
        Preconditions.checkArgument((frameTimes.size() == this.frames.size() ? 1 : 0) != 0, (Object)("Animation has " + this.frames.size() + " frame, but provided " + frameTimes.size()));
        for (int i = 0; i < frameTimes.size(); ++i) {
            this.frames.get((int)i).frameTime = frameTimes.get(i).floatValue();
        }
    }

    public float getFrameTime(int index) {
        return this.frames.get((int)index).frameTime;
    }

    @Override
    public boolean isLoop() {
        return this.loop;
    }

    private List<FrameInfo> copyFrames() {
        return this.frames.stream().map(frame -> new FrameInfo(frame.image, frame.frameTime)).collect(Collectors.toList());
    }

    public Animation reverse() {
        List<FrameInfo> reverseFrames = this.copyFrames();
        Collections.reverse(reverseFrames);
        return new Animation(reverseFrames, this.loop);
    }

    public Animation append(Animation other) {
        ArrayList<FrameInfo> combinedFrames = new ArrayList<FrameInfo>();
        combinedFrames.addAll(this.copyFrames());
        combinedFrames.addAll(other.copyFrames());
        return new Animation(combinedFrames, this.loop);
    }

    public Animation repeat(int times) {
        Preconditions.checkArgument((times >= 2 ? 1 : 0) != 0, (Object)"Must repeat at least twice");
        ArrayList<FrameInfo> repeatingFrames = new ArrayList<FrameInfo>();
        for (int i = 0; i < times; ++i) {
            repeatingFrames.addAll(this.copyFrames());
        }
        return new Animation(repeatingFrames, this.loop);
    }

    public Animation mirror() {
        return this.append(this.reverse());
    }

    private static class FrameInfo {
        private Image image;
        private float frameTime;

        public FrameInfo(Image image, float frameTime) {
            this.image = image;
            this.frameTime = frameTime;
        }
    }
}

