/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.Rect;

public class SpriteSheet {
    private Image image;
    private Map<String, Rect> regions;
    private Map<String, Image> subImageCache;

    public SpriteSheet(Image image) {
        this.image = image;
        this.regions = new HashMap<String, Rect>();
        this.subImageCache = new HashMap<String, Image>();
    }

    public Image markRegion(String name, Rect region) {
        Preconditions.checkArgument((!this.regions.containsKey(name) ? 1 : 0) != 0, (Object)("Sprite sheet already contains a region with the same name: " + name));
        Preconditions.checkArgument((boolean)this.isValidRegion(region), (Object)("Invalid region: " + name + " @ " + region));
        this.regions.put(name, region);
        return this.get(name);
    }

    protected boolean isValidRegion(Rect region) {
        if (this.image.getWidth() > 0 && this.image.getHeight() > 0) {
            Rect imageBounds = new Rect(0.0f, 0.0f, this.image.getWidth(), this.image.getHeight());
            return imageBounds.contains(region);
        }
        return true;
    }

    public Image get(String name) {
        Preconditions.checkArgument((boolean)this.regions.containsKey(name), (Object)("Unknown region: " + name));
        if (this.subImageCache.containsKey(name)) {
            return this.subImageCache.get(name);
        }
        Rect region = this.getRegion(name);
        Image subImage = this.image.extractRegion(region);
        this.subImageCache.put(name, subImage);
        return subImage;
    }

    public List<Image> get(String firstRegionName, String secondRegionName, String ... rest) {
        ArrayList<Image> result = new ArrayList<Image>();
        result.add(this.get(firstRegionName));
        result.add(this.get(secondRegionName));
        for (String name : rest) {
            result.add(this.get(name));
        }
        return result;
    }

    public Rect getRegion(String name) {
        Rect region = this.regions.get(name);
        Preconditions.checkArgument((region != null ? 1 : 0) != 0, (Object)("Unknown region: " + name));
        return region;
    }

    public Set<String> getRegionNames() {
        return this.regions.keySet();
    }

    @Deprecated
    public Image getImage() {
        return this.image;
    }
}

