/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Shape;

public class Circle
implements Shape {
    private Point2D center;
    private float radius;

    public Circle(Point2D center, float radius) {
        Preconditions.checkArgument((radius > 0.0f ? 1 : 0) != 0, (Object)("Invalid radius: " + radius));
        this.center = center.copy();
        this.radius = radius;
    }

    public Circle(float x, float y, float radius) {
        this(new Point2D(x, y), radius);
    }

    public Point2D getCenter() {
        return this.center;
    }

    public float getCenterX() {
        return this.center.getX();
    }

    public float getCenterY() {
        return this.center.getY();
    }

    public float getRadius() {
        return this.radius;
    }

    public float getDiameter() {
        return this.radius * 2.0f;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.calculateDistance(p) <= this.radius;
    }

    public boolean intersects(Circle other) {
        return this.calculateDistance(other) <= this.radius + other.radius;
    }

    public float calculateDistance(Point2D p) {
        return this.center.calculateDistance(p);
    }

    public float calculateDistance(Circle other) {
        return this.center.calculateDistance(other.center);
    }
}

