/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;

public class RotatingBuffer {
    private float[] values;
    private int index;
    private int filled;
    private float outlierThreshold;

    public RotatingBuffer(int capacity, float outlierThreshold) {
        Preconditions.checkArgument((capacity >= 1 ? 1 : 0) != 0, (Object)("Invalid capacity: " + capacity));
        this.values = new float[capacity];
        this.index = 0;
        this.filled = 0;
        this.outlierThreshold = outlierThreshold;
    }

    public RotatingBuffer(int capacity) {
        this(capacity, Float.MAX_VALUE);
    }

    public void add(float value) {
        if (value >= this.outlierThreshold) {
            return;
        }
        this.values[this.index] = value;
        ++this.index;
        if (this.index >= this.values.length) {
            this.index = 0;
        }
        if (this.filled < this.values.length) {
            ++this.filled;
        }
    }

    public float getAverageValue() {
        float total = 0.0f;
        int count = 0;
        for (int i = 0; i < this.filled; ++i) {
            total += this.values[i];
            ++count;
        }
        if (count > 0) {
            return total / (float)count;
        }
        return 0.0f;
    }
}

