/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.PolygonModel;
import nl.colorize.multimedialib.graphics.SpriteSheet;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Audio;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GeometryBuilder;
import nl.colorize.util.ApplicationData;
import nl.colorize.util.CSVRecord;

public interface MediaLoader {
    public Image loadImage(FilePointer var1);

    default public SpriteSheet loadSpriteSheetCSV(FilePointer imageFile, FilePointer metadataFile) {
        Preconditions.checkArgument((boolean)metadataFile.getPath().endsWith(".csv"), (Object)"Only sprite sheet metadata in CSV format is supported");
        Image image = this.loadImage(imageFile);
        List metadata = CSVRecord.parseRecords((String)this.loadText(metadataFile), (String)";", (boolean)true);
        SpriteSheet spriteSheet = new SpriteSheet(image);
        for (CSVRecord region : metadata) {
            Rect bounds = new Rect(region.getFloat(1), region.getFloat(2), region.getFloat(3), region.getFloat(4));
            spriteSheet.markRegion(region.get(0), bounds);
        }
        return spriteSheet;
    }

    public Audio loadAudio(FilePointer var1);

    public TTFont loadFont(FilePointer var1, String var2, int var3, ColorRGB var4, boolean var5);

    default public TTFont loadFont(FilePointer file, String family, int size, ColorRGB color) {
        return this.loadFont(file, family, size, color, false);
    }

    default public TTFont loadDefaultFont(int size, ColorRGB color) {
        FilePointer file = new FilePointer("OpenSans-Regular.ttf");
        return this.loadFont(file, "Open Sans", size, color, false);
    }

    public PolygonModel loadModel(FilePointer var1);

    public String loadText(FilePointer var1);

    default public List<String> loadTextLines(FilePointer file) {
        return Splitter.on((String)"\n").splitToList((CharSequence)this.loadText(file));
    }

    public boolean containsResourceFile(FilePointer var1);

    public ApplicationData loadApplicationData(String var1, String var2);

    public void saveApplicationData(ApplicationData var1, String var2, String var3);

    public GeometryBuilder getGeometryBuilder();
}

