/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.headless;

import com.google.common.annotations.VisibleForTesting;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.java2d.StandardMediaLoader;

@VisibleForTesting
public class HeadlessMediaLoader
extends StandardMediaLoader {
    private boolean graphicsEnvironmentEnabled;
    public static final int HEADLESS_IMAGE_SIZE = 128;

    public HeadlessMediaLoader(boolean graphicsEnvironmentEnabled) {
        this.graphicsEnvironmentEnabled = graphicsEnvironmentEnabled;
    }

    @Override
    public Image loadImage(FilePointer file) {
        if (this.graphicsEnvironmentEnabled) {
            return super.loadImage(file);
        }
        return new HeadlessImage();
    }

    private static class HeadlessImage
    implements Image {
        private HeadlessImage() {
        }

        @Override
        public Rect getRegion() {
            return new Rect(0.0f, 0.0f, 128.0f, 128.0f);
        }

        @Override
        public Image extractRegion(Rect region) {
            return this;
        }

        @Override
        public ColorRGB getColor(int x, int y) {
            return ColorRGB.BLACK;
        }

        @Override
        public int getAlpha(int x, int y) {
            return 100;
        }

        @Override
        public Image tint(ColorRGB color) {
            return this;
        }
    }
}

