/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import com.google.common.base.Charsets;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.multimedialib.renderer.NetworkAccess;
import nl.colorize.multimedialib.renderer.NetworkConnection;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.Task;
import nl.colorize.util.http.Headers;
import nl.colorize.util.http.HttpMessage;
import nl.colorize.util.http.Method;
import nl.colorize.util.http.PostData;
import nl.colorize.util.http.URLLoader;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class StandardNetworkAccess
implements NetworkAccess {
    private static final Logger LOGGER = LogHelper.getLogger(StandardNetworkAccess.class);

    @Override
    public Task<String> get(String url, Headers headers) {
        return this.send(Method.GET, url, headers, null);
    }

    @Override
    public Task<String> post(String url, Headers headers, PostData body) {
        return this.send(Method.POST, url, headers, body);
    }

    public Task<String> send(Method method, String url, Headers headers, PostData body) {
        URLLoader request = URLLoader.create((Method)method, (String)url, (Charset)StandardCharsets.UTF_8);
        request.addHeader("X-Requested-With", "MultimediaLib");
        if (headers != null) {
            request.addHeaders(headers);
        }
        if (body != null) {
            request.setBody(body);
        }
        return request.sendBackgroundRequest().pipe(HttpMessage::getBody);
    }

    @Override
    public boolean isWebSocketSupported() {
        return true;
    }

    @Override
    public NetworkConnection connectWebSocket(String uri) {
        JavaWebSocketClient client = new JavaWebSocketClient(URI.create(uri));
        client.connect();
        return client.connection;
    }

    @Override
    public boolean isWebRtcSupported() {
        return false;
    }

    @Override
    public NetworkConnection connectWebRTC(String id) {
        throw new UnsupportedOperationException("WebRTC not supported by platform " + Platform.getPlatformName());
    }

    private static class JavaWebSocketClient
    extends WebSocketClient {
        private NetworkConnection connection = new NetworkConnection(arg_0 -> ((JavaWebSocketClient)this).send(arg_0));

        public JavaWebSocketClient(URI uri) {
            super(uri);
        }

        public void onOpen(ServerHandshake handshake) {
            LOGGER.info("Web socket connection: " + handshake.getHttpStatusMessage());
            this.connection.receiveID(UUID.randomUUID().toString());
            this.connection.connect();
            this.send("__init");
        }

        public void onClose(int code, String reason, boolean remote) {
            LOGGER.info("Web socket connection closed");
            this.connection.disconnect();
        }

        public void onMessage(String message) {
            this.connection.queueReceivedMessage(message);
        }

        public void onMessage(ByteBuffer buffer) {
            String message = new String(buffer.array(), Charsets.UTF_8);
            this.connection.queueReceivedMessage(message);
        }

        public void onError(Exception e) {
            LOGGER.log(Level.WARNING, "Web socket error", e);
        }
    }
}

