/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.FilePointer;

public class GDXImage
implements Image {
    private FilePointer origin;
    private Texture texture;
    private TextureRegion textureRegion;
    private Pixmap textureData;
    private Rect bounds;

    protected GDXImage(FilePointer origin, Texture texture, Rect bounds) {
        float u1 = bounds.getX() / (float)texture.getWidth();
        float v1 = bounds.getY() / (float)texture.getHeight();
        float u2 = bounds.getEndX() / (float)texture.getWidth();
        float v2 = bounds.getEndY() / (float)texture.getHeight();
        this.origin = origin;
        this.texture = texture;
        this.textureRegion = new TextureRegion(texture, u1, v1, u2, v2);
        this.bounds = bounds;
    }

    protected GDXImage(FilePointer origin, Texture texture) {
        this(origin, texture, new Rect(0.0f, 0.0f, texture.getWidth(), texture.getHeight()));
    }

    public Texture getTexture() {
        return this.texture;
    }

    public TextureRegion getTextureRegion() {
        return this.textureRegion;
    }

    @Override
    public Rect getRegion() {
        return this.bounds;
    }

    @Override
    public Image extractRegion(Rect region) {
        return new GDXImage(this.origin, this.texture, region);
    }

    private void loadTextureData() {
        if (this.textureData == null) {
            TextureData data = this.texture.getTextureData();
            data.prepare();
            this.textureData = data.consumePixmap();
        }
    }

    @Override
    public ColorRGB getColor(int x, int y) {
        this.loadTextureData();
        int rgba = this.textureData.getPixel(x, y);
        return new ColorRGB(rgba);
    }

    @Override
    public int getAlpha(int x, int y) {
        this.loadTextureData();
        int rgba = this.textureData.getPixel(x, y);
        int alpha = rgba >> 24 & 0xFF;
        return Math.round((float)alpha / 2.55f);
    }

    @Override
    public Image tint(ColorRGB color) {
        TextureData textureData = this.texture.getTextureData();
        textureData.prepare();
        Pixmap original = textureData.consumePixmap();
        Pixmap tinted = new Pixmap(this.getWidth(), this.getHeight(), Pixmap.Format.RGBA8888);
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                int rgba = original.getPixel(Math.round(this.bounds.getX()) + x, Math.round(this.bounds.getY()) + y);
                int maskRGBA = Color.rgba8888((float)((float)color.getR() / 255.0f), (float)((float)color.getG() / 2.0f), (float)((float)color.getB() / 255.0f), (float)(new Color((int)rgba).a * 100.0f));
                tinted.drawPixel(x, y, maskRGBA);
            }
        }
        Texture texture = new Texture(tinted);
        original.dispose();
        tinted.dispose();
        return new GDXImage(this.origin, texture);
    }

    public String toString() {
        return this.origin + "@" + this.bounds;
    }
}

