/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.util.CSVRecord;
import nl.colorize.util.PlatformFamily;

public class TeaInputDevice
implements InputDevice,
Updatable {
    private Canvas canvas;
    private PlatformFamily platform;
    private Map<String, Pointer> pointers;
    private Set<Integer> keysDown;
    private Set<Integer> keysUp;
    private static final Map<String, Integer> POINTER_EVENTS = new ImmutableMap.Builder().put((Object)"mousedown", (Object)1).put((Object)"mouseup", (Object)2).put((Object)"mousemove", (Object)0).put((Object)"mouseout", (Object)2).put((Object)"touchstart", (Object)1).put((Object)"touchend", (Object)2).put((Object)"touchmove", (Object)1).put((Object)"touchcancel", (Object)2).build();
    private static final Map<KeyCode, Integer> BROWSER_KEY_CODE_MAPPING = new ImmutableMap.Builder().put((Object)KeyCode.LEFT, (Object)37).put((Object)KeyCode.RIGHT, (Object)39).put((Object)KeyCode.UP, (Object)38).put((Object)KeyCode.DOWN, (Object)40).put((Object)KeyCode.ENTER, (Object)13).put((Object)KeyCode.SPACEBAR, (Object)32).put((Object)KeyCode.ESCAPE, (Object)27).put((Object)KeyCode.SHIFT, (Object)16).put((Object)KeyCode.BACKSPACE, (Object)8).put((Object)KeyCode.A, (Object)65).put((Object)KeyCode.B, (Object)66).put((Object)KeyCode.C, (Object)67).put((Object)KeyCode.D, (Object)68).put((Object)KeyCode.E, (Object)69).put((Object)KeyCode.F, (Object)70).put((Object)KeyCode.G, (Object)71).put((Object)KeyCode.H, (Object)72).put((Object)KeyCode.I, (Object)73).put((Object)KeyCode.J, (Object)74).put((Object)KeyCode.K, (Object)75).put((Object)KeyCode.L, (Object)76).put((Object)KeyCode.M, (Object)77).put((Object)KeyCode.N, (Object)78).put((Object)KeyCode.O, (Object)79).put((Object)KeyCode.P, (Object)80).put((Object)KeyCode.Q, (Object)81).put((Object)KeyCode.R, (Object)82).put((Object)KeyCode.S, (Object)83).put((Object)KeyCode.T, (Object)84).put((Object)KeyCode.U, (Object)85).put((Object)KeyCode.V, (Object)86).put((Object)KeyCode.W, (Object)87).put((Object)KeyCode.X, (Object)88).put((Object)KeyCode.Y, (Object)89).put((Object)KeyCode.Z, (Object)90).put((Object)KeyCode.N1, (Object)49).put((Object)KeyCode.N2, (Object)50).put((Object)KeyCode.N3, (Object)51).put((Object)KeyCode.N4, (Object)52).put((Object)KeyCode.N5, (Object)53).put((Object)KeyCode.N6, (Object)54).put((Object)KeyCode.N7, (Object)55).put((Object)KeyCode.N8, (Object)56).put((Object)KeyCode.N9, (Object)57).put((Object)KeyCode.N0, (Object)48).put((Object)KeyCode.F1, (Object)112).put((Object)KeyCode.F2, (Object)113).put((Object)KeyCode.F3, (Object)114).put((Object)KeyCode.F4, (Object)115).put((Object)KeyCode.F5, (Object)116).put((Object)KeyCode.F6, (Object)117).put((Object)KeyCode.F7, (Object)118).put((Object)KeyCode.F8, (Object)119).put((Object)KeyCode.F9, (Object)120).put((Object)KeyCode.F10, (Object)121).put((Object)KeyCode.F11, (Object)122).put((Object)KeyCode.F12, (Object)123).build();

    public TeaInputDevice(Canvas canvas, PlatformFamily platform) {
        this.canvas = canvas;
        this.platform = platform;
        this.pointers = new HashMap<String, Pointer>();
        this.keysDown = new HashSet<Integer>();
        this.keysUp = new HashSet<Integer>();
    }

    @Override
    public void update(float deltaTime) {
        this.updatePointerState();
        this.updateKeyboardState();
    }

    private void updatePointerState() {
        ImmutableList snapshot = ImmutableList.copyOf(this.pointers.values());
        for (Pointer pointer : snapshot) {
            if (pointer.state != 2) continue;
            this.pointers.remove(pointer.identifier);
        }
        for (String pointerEvent : Browser.flushPointerEventBuffer()) {
            CSVRecord data = CSVRecord.parseRecord((String)pointerEvent, (String)";");
            Pointer pointer = this.getPointer(data.get(1));
            pointer.location.set(data.getFloat(2), data.getFloat(3));
            String eventType = data.get(0);
            int eventState = this.getPointerEventState(eventType);
            pointer.state = Math.max(pointer.state, eventState);
        }
    }

    private Pointer getPointer(String identifier) {
        Pointer pointer = this.pointers.get(identifier);
        if (pointer == null) {
            pointer = new Pointer(identifier);
            this.pointers.put(identifier, pointer);
        }
        return pointer;
    }

    private int getPointerEventState(String eventType) {
        Integer eventState = POINTER_EVENTS.get(eventType);
        Preconditions.checkArgument((eventState != null ? 1 : 0) != 0, (Object)("Unknown pointer event type: " + eventType));
        return eventState;
    }

    private void updateKeyboardState() {
        for (KeyCode keyCode : KeyCode.values()) {
            Integer browserKeyCode = BROWSER_KEY_CODE_MAPPING.get((Object)keyCode);
            int keyState = Math.round(Browser.getKeyState(browserKeyCode));
            if (keyState == 1) {
                this.keysDown.add(browserKeyCode);
                this.keysUp.remove(browserKeyCode);
                continue;
            }
            if (this.keysDown.contains(browserKeyCode)) {
                this.keysDown.remove(browserKeyCode);
                this.keysUp.add(browserKeyCode);
                continue;
            }
            this.keysDown.remove(browserKeyCode);
            this.keysUp.remove(browserKeyCode);
        }
    }

    @Override
    public List<Point2D> getPointers() {
        return this.pointers.values().stream().map(pointer -> pointer.getCanvasPosition(this.canvas)).collect(Collectors.toList());
    }

    @Override
    public boolean isPointerPressed(Rect area) {
        return this.pointers.values().stream().filter(pointer -> pointer.state == 1).anyMatch(pointer -> area.contains(pointer.getCanvasPosition(this.canvas)));
    }

    @Override
    public boolean isPointerReleased(Rect area) {
        return this.pointers.values().stream().filter(pointer -> pointer.state == 2).anyMatch(pointer -> area.contains(pointer.getCanvasPosition(this.canvas)));
    }

    @Override
    public boolean isTouchAvailable() {
        return this.platform.isMobile();
    }

    @Override
    public boolean isKeyboardAvailable() {
        return !this.platform.isMobile();
    }

    @Override
    public boolean isKeyPressed(KeyCode keyCode) {
        return this.keysDown.contains(BROWSER_KEY_CODE_MAPPING.get((Object)keyCode));
    }

    @Override
    public boolean isKeyReleased(KeyCode keyCode) {
        return this.keysUp.contains(BROWSER_KEY_CODE_MAPPING.get((Object)keyCode));
    }

    @Override
    public String requestTextInput(String label, String initialValue) {
        return Browser.prompt(label, initialValue);
    }

    private static class Pointer {
        private String identifier;
        private Point2D location;
        private int state;

        public Pointer(String identifier) {
            this.identifier = identifier;
            this.location = new Point2D(0.0f, 0.0f);
            this.state = 0;
        }

        public Point2D getCanvasPosition(Canvas canvas) {
            float devicePixelRatio = Browser.getDevicePixelRatio();
            float canvasX = canvas.toCanvasX(Math.round(this.location.getX() * devicePixelRatio));
            float canvasY = canvas.toCanvasY(Math.round(this.location.getY() * devicePixelRatio));
            return new Point2D(canvasX, canvasY);
        }
    }
}

