/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.graphics.AnimationInfo;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.PolygonModel;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.renderer.Audio;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GeometryBuilder;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.TeaAudio;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;
import nl.colorize.multimedialib.renderer.teavm.TeaModel;
import nl.colorize.util.ApplicationData;

public class TeaMediaLoader
implements MediaLoader,
GeometryBuilder {
    private Map<FilePointer, ProgressTracker> progressTrackers = new LinkedHashMap<FilePointer, ProgressTracker>();
    private List<TeaImage> loadedImages = new ArrayList<TeaImage>();
    private int nextAudioId = 1;
    private int nextFontId = 1;
    private static final Splitter LINE_SPLITTER = Splitter.on((String)"\n").trimResults().omitEmptyStrings();

    public boolean checkLoadingProgress() {
        LinkedHashMap<FilePointer, ProgressTracker> remaining = new LinkedHashMap<FilePointer, ProgressTracker>();
        for (Map.Entry<FilePointer, ProgressTracker> entry : this.progressTrackers.entrySet()) {
            if (entry.getValue().isLoadingComplete()) continue;
            remaining.put(entry.getKey(), entry.getValue());
        }
        this.progressTrackers = remaining;
        return remaining.isEmpty();
    }

    @Override
    public Image loadImage(FilePointer file) {
        String id = String.valueOf(this.loadedImages.size() + 1);
        Browser.loadImage(id, this.normalizeFilePath(file, false));
        TeaImage imagePointer = new TeaImage(id, file, null);
        this.loadedImages.add(imagePointer);
        this.progressTrackers.put(file, () -> Browser.getImageHeight(id) > 0.0f);
        return imagePointer;
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        String id = String.valueOf(this.nextAudioId);
        Browser.loadAudio(id, this.normalizeFilePath(file, false));
        ++this.nextAudioId;
        return new TeaAudio(id);
    }

    @Override
    public TTFont loadFont(FilePointer file, String family, int size, ColorRGB color, boolean bold) {
        String id = String.valueOf(this.nextFontId);
        Browser.loadFont(id, this.normalizeFilePath(file, false), family);
        ++this.nextFontId;
        return new TTFont(family, size, color, false);
    }

    @Override
    public PolygonModel loadModel(FilePointer file) {
        UUID id = UUID.randomUUID();
        HashMap<String, AnimationInfo> animations = new HashMap<String, AnimationInfo>();
        ArrayList loadCount = new ArrayList();
        Browser.loadModel(id.toString(), file.getPath(), (names, durations) -> {
            for (int i = 0; i < names.length; ++i) {
                AnimationInfo animation = this.toAnimationInfo(durations[i]);
                animations.put(names[i], animation);
            }
            loadCount.add(String.valueOf(loadCount.size() + 1));
        });
        this.progressTrackers.put(file, () -> loadCount.size() > 0);
        return new TeaModel(UUID.randomUUID(), id, animations, false);
    }

    private AnimationInfo toAnimationInfo(final float duration) {
        return new AnimationInfo(){

            @Override
            public float getDuration() {
                return duration;
            }

            @Override
            public boolean isLoop() {
                return false;
            }
        };
    }

    @Override
    public String loadText(FilePointer file) {
        return Browser.loadTextResourceFile(this.normalizeFilePath(file, true));
    }

    @Override
    public boolean containsResourceFile(FilePointer file) {
        String fileEntry = file.getPath();
        if (fileEntry.indexOf(47) != -1) {
            fileEntry = fileEntry.substring(fileEntry.lastIndexOf(47) + 1);
        }
        for (FilePointer entry : this.loadResourceFileManifest()) {
            if (!entry.getPath().equals(fileEntry)) continue;
            return true;
        }
        return false;
    }

    private List<FilePointer> loadResourceFileManifest() {
        String manifest = this.loadText(new FilePointer("resource-file-manifest"));
        return LINE_SPLITTER.splitToList((CharSequence)manifest).stream().map(path -> new FilePointer((String)path)).collect(Collectors.toList());
    }

    protected String normalizeFilePath(FilePointer file, boolean replaceDot) {
        String normalized = file.getPath();
        if (normalized.indexOf(47) != -1) {
            normalized = normalized.substring(normalized.lastIndexOf(47) + 1);
        }
        if (replaceDot) {
            normalized = normalized.replace(".", "_");
        }
        return normalized;
    }

    @Override
    public ApplicationData loadApplicationData(String appName, String fileName) {
        String value = Browser.getLocalStorage(fileName);
        if (value == null || value.isEmpty()) {
            return new ApplicationData(new Properties());
        }
        return new ApplicationData(value);
    }

    @Override
    public void saveApplicationData(ApplicationData data, String appName, String fileName) {
        Browser.setLocalStorage(fileName, data.serialize());
    }

    @Override
    public GeometryBuilder getGeometryBuilder() {
        return this;
    }

    @Override
    public PolygonModel createQuad(Point2D size, ColorRGB color) {
        return this.createBox(new Point3D(size.getX(), 0.001f, size.getY()), color);
    }

    @Override
    public PolygonModel createQuad(Point2D size, Image image) {
        return this.createBox(new Point3D(size.getX(), 0.001f, size.getY()), image);
    }

    @Override
    public PolygonModel createBox(Point3D size, ColorRGB color) {
        UUID id = UUID.randomUUID();
        Browser.createBox(id.toString(), size.getX(), size.getY(), size.getZ(), color.toHex(), null);
        return new TeaModel(UUID.randomUUID(), id, Collections.emptyMap(), true);
    }

    @Override
    public PolygonModel createBox(Point3D size, Image image) {
        UUID id = UUID.randomUUID();
        TeaImage texture = (TeaImage)image;
        Browser.createBox(id.toString(), size.getX(), size.getY(), size.getZ(), null, texture.getOrigin().getPath());
        return new TeaModel(UUID.randomUUID(), id, Collections.emptyMap(), true);
    }

    @Override
    public PolygonModel createSphere(float diameter, ColorRGB color) {
        UUID id = UUID.randomUUID();
        Browser.createSphere(id.toString(), diameter, color.toHex(), null);
        return new TeaModel(UUID.randomUUID(), id, Collections.emptyMap(), true);
    }

    @Override
    public PolygonModel createSphere(float diameter, Image image) {
        UUID id = UUID.randomUUID();
        TeaImage texture = (TeaImage)image;
        Browser.createSphere(id.toString(), diameter, null, texture.getOrigin().getPath());
        return new TeaModel(UUID.randomUUID(), id, Collections.emptyMap(), true);
    }

    @FunctionalInterface
    private static interface ProgressTracker {
        public boolean isLoadingComplete();
    }
}

