/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import nl.colorize.multimedialib.graphics.AnimationInfo;
import nl.colorize.multimedialib.graphics.PolygonModel;
import nl.colorize.multimedialib.graphics.Transform3D;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.renderer.teavm.Browser;

public class TeaModel
implements PolygonModel {
    private UUID modelId;
    private UUID meshId;
    private Map<String, AnimationInfo> animations;
    private Transform3D transform;
    private boolean primitive;

    protected TeaModel(UUID modelId, UUID meshId, Map<String, AnimationInfo> animations, boolean primitive) {
        this.modelId = modelId;
        this.meshId = meshId;
        this.animations = ImmutableMap.copyOf(animations);
        this.transform = new Transform3D();
        this.primitive = primitive;
    }

    @Override
    public void attach() {
        Browser.addModel(this.modelId.toString(), this.meshId.toString());
    }

    @Override
    public void detach() {
        Browser.removeModel(this.modelId.toString());
    }

    @Override
    public void update(float deltaTime) {
        Point3D position = this.transform.getPosition();
        float rotationX = (float)Math.toRadians(this.transform.getRotationX() * this.transform.getRotationAmount());
        float rotationY = (float)Math.toRadians(this.transform.getRotationY() * this.transform.getRotationAmount()) + this.getRotationOffset();
        float rotationZ = (float)Math.toRadians(this.transform.getRotationZ() * this.transform.getRotationAmount());
        Browser.syncModel(this.modelId.toString(), position.getX(), position.getY(), position.getZ(), rotationX, rotationY, rotationZ, this.transform.getScaleX(), this.transform.getScaleY(), this.transform.getScaleZ());
    }

    private float getRotationOffset() {
        return this.primitive ? -1.5707964f : 0.0f;
    }

    @Override
    public Transform3D getTransform() {
        return this.transform;
    }

    @Override
    public Map<String, AnimationInfo> getAnimations() {
        return this.animations;
    }

    @Override
    public void playAnimation(String animation, boolean loop) {
        Preconditions.checkArgument((boolean)this.getAnimations().containsKey(animation), (Object)("Unknown animation: " + animation));
        Browser.playAnimation(this.modelId.toString(), this.meshId.toString(), animation, loop);
    }

    @Override
    public PolygonModel copy() {
        return new TeaModel(UUID.randomUUID(), this.meshId, this.animations, this.primitive);
    }
}

